package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1TestToolSpecBuilder extends V1alpha1TestToolSpecFluentImpl<V1alpha1TestToolSpecBuilder> implements VisitableBuilder<V1alpha1TestToolSpec,V1alpha1TestToolSpecBuilder>{

    V1alpha1TestToolSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1TestToolSpecBuilder(){
            this(true);
    }
    public V1alpha1TestToolSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1TestToolSpec(), validationEnabled);
    }
    public V1alpha1TestToolSpecBuilder(V1alpha1TestToolSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1TestToolSpecBuilder(V1alpha1TestToolSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1TestToolSpec(), validationEnabled);
    }
    public V1alpha1TestToolSpecBuilder(V1alpha1TestToolSpecFluent<?> fluent,V1alpha1TestToolSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1TestToolSpecBuilder(V1alpha1TestToolSpecFluent<?> fluent,V1alpha1TestToolSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withData(instance.getData());

            fluent.withHttp(instance.getHttp());

            fluent.withPublic(instance.isPublic());

            fluent.withSecret(instance.getSecret());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1TestToolSpecBuilder(V1alpha1TestToolSpec instance){
            this(instance,true);
    }
    public V1alpha1TestToolSpecBuilder(V1alpha1TestToolSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withData(instance.getData());

            this.withHttp(instance.getHttp());

            this.withPublic(instance.isPublic());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1TestToolSpec build(){
            V1alpha1TestToolSpec buildable = new V1alpha1TestToolSpec();
            buildable.setData(fluent.getData());
            buildable.setHttp(fluent.getHttp());
            buildable.setPublic(fluent.isPublic());
            buildable.setSecret(fluent.getSecret());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1TestToolSpecBuilder that = (V1alpha1TestToolSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
