package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1RoleMappingBuilder extends V1alpha1RoleMappingFluentImpl<V1alpha1RoleMappingBuilder> implements VisitableBuilder<V1alpha1RoleMapping,V1alpha1RoleMappingBuilder>{

    V1alpha1RoleMappingFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1RoleMappingBuilder(){
            this(true);
    }
    public V1alpha1RoleMappingBuilder(Boolean validationEnabled){
            this(new V1alpha1RoleMapping(), validationEnabled);
    }
    public V1alpha1RoleMappingBuilder(V1alpha1RoleMappingFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1RoleMappingBuilder(V1alpha1RoleMappingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1RoleMapping(), validationEnabled);
    }
    public V1alpha1RoleMappingBuilder(V1alpha1RoleMappingFluent<?> fluent,V1alpha1RoleMapping instance){
            this(fluent, instance, true);
    }
    public V1alpha1RoleMappingBuilder(V1alpha1RoleMappingFluent<?> fluent,V1alpha1RoleMapping instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1RoleMappingBuilder(V1alpha1RoleMapping instance){
            this(instance,true);
    }
    public V1alpha1RoleMappingBuilder(V1alpha1RoleMapping instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1RoleMapping build(){
            V1alpha1RoleMapping buildable = new V1alpha1RoleMapping();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1RoleMappingBuilder that = (V1alpha1RoleMappingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
