package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import io.kubernetes.client.models.V1ObjectMeta;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateTaskInstanceFluentImpl<A extends V1alpha1PipelineTemplateTaskInstanceFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTemplateTaskInstanceFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMeta metadata;
    private V1alpha1PipelineTemplateTaskInstanceSpecBuilder spec;

    public V1alpha1PipelineTemplateTaskInstanceFluentImpl(){
    }
    public V1alpha1PipelineTemplateTaskInstanceFluentImpl(V1alpha1PipelineTemplateTaskInstance instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public V1ObjectMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ObjectMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTemplateTaskInstanceSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V1alpha1PipelineTemplateTaskInstanceSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1alpha1PipelineTemplateTaskInstanceSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new V1alpha1PipelineTemplateTaskInstanceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V1alpha1PipelineTemplateTaskInstanceFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskInstanceFluent.SpecNested<A> withNewSpecLike(V1alpha1PipelineTemplateTaskInstanceSpec item){
            return new SpecNestedImpl(item);
    }

    public V1alpha1PipelineTemplateTaskInstanceFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V1alpha1PipelineTemplateTaskInstanceFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V1alpha1PipelineTemplateTaskInstanceSpecBuilder().build());
    }

    public V1alpha1PipelineTemplateTaskInstanceFluent.SpecNested<A> editOrNewSpecLike(V1alpha1PipelineTemplateTaskInstanceSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateTaskInstanceFluentImpl that = (V1alpha1PipelineTemplateTaskInstanceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class SpecNestedImpl<N> extends V1alpha1PipelineTemplateTaskInstanceSpecFluentImpl<V1alpha1PipelineTemplateTaskInstanceFluent.SpecNested<N>> implements V1alpha1PipelineTemplateTaskInstanceFluent.SpecNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateTaskInstanceSpecBuilder builder;
    
            SpecNestedImpl(V1alpha1PipelineTemplateTaskInstanceSpec item){
                    this.builder = new V1alpha1PipelineTemplateTaskInstanceSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V1alpha1PipelineTemplateTaskInstanceSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskInstanceFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}


}
