package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateTaskInstanceBuilder extends V1alpha1PipelineTemplateTaskInstanceFluentImpl<V1alpha1PipelineTemplateTaskInstanceBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateTaskInstance,V1alpha1PipelineTemplateTaskInstanceBuilder>{

    V1alpha1PipelineTemplateTaskInstanceFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateTaskInstanceBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateTaskInstanceBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateTaskInstance(), validationEnabled);
    }
    public V1alpha1PipelineTemplateTaskInstanceBuilder(V1alpha1PipelineTemplateTaskInstanceFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateTaskInstanceBuilder(V1alpha1PipelineTemplateTaskInstanceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateTaskInstance(), validationEnabled);
    }
    public V1alpha1PipelineTemplateTaskInstanceBuilder(V1alpha1PipelineTemplateTaskInstanceFluent<?> fluent,V1alpha1PipelineTemplateTaskInstance instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateTaskInstanceBuilder(V1alpha1PipelineTemplateTaskInstanceFluent<?> fluent,V1alpha1PipelineTemplateTaskInstance instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateTaskInstanceBuilder(V1alpha1PipelineTemplateTaskInstance instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateTaskInstanceBuilder(V1alpha1PipelineTemplateTaskInstance instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateTaskInstance build(){
            V1alpha1PipelineTemplateTaskInstance buildable = new V1alpha1PipelineTemplateTaskInstance();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateTaskInstanceBuilder that = (V1alpha1PipelineTemplateTaskInstanceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
