package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class V1alpha1PipelineTemplateTaskFluentImpl<A extends V1alpha1PipelineTemplateTaskFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTemplateTaskFluent<A>{

    private V1alpha1JenkinsAgentBuilder agent;
    private V1alpha1PipelineTaskApproveBuilder approve;
    private Map<String,List<String>> conditions;
    private V1alpha1I18nNameBuilder display;
    private List<V1alpha1PipelineEnvironmentBuilder> environments;
    private String kind;
    private String name;
    private V1alpha1PipelineTaskOptionBuilder options;
    private List<V1alpha1PipelineTaskArgumentActionBuilder> relation;
    private String type;

    public V1alpha1PipelineTemplateTaskFluentImpl(){
    }
    public V1alpha1PipelineTemplateTaskFluentImpl(V1alpha1PipelineTemplateTask instance){
            this.withAgent(instance.getAgent());

            this.withApprove(instance.getApprove());

            this.withConditions(instance.getConditions());

            this.withDisplay(instance.getDisplay());

            this.withEnvironments(instance.getEnvironments());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withOptions(instance.getOptions());

            this.withRelation(instance.getRelation());

            this.withType(instance.getType());

    }

    
/**
 * This method has been deprecated, please use method buildAgent instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1JenkinsAgent getAgent(){
            return this.agent!=null?this.agent.build():null;
    }

    public V1alpha1JenkinsAgent buildAgent(){
            return this.agent!=null?this.agent.build():null;
    }

    public A withAgent(V1alpha1JenkinsAgent agent){
            _visitables.get("agent").remove(this.agent);
            if (agent!=null){ this.agent= new V1alpha1JenkinsAgentBuilder(agent); _visitables.get("agent").add(this.agent);} return (A) this;
    }

    public Boolean hasAgent(){
            return this.agent != null;
    }

    public V1alpha1PipelineTemplateTaskFluent.AgentNested<A> withNewAgent(){
            return new AgentNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskFluent.AgentNested<A> withNewAgentLike(V1alpha1JenkinsAgent item){
            return new AgentNestedImpl(item);
    }

    public V1alpha1PipelineTemplateTaskFluent.AgentNested<A> editAgent(){
            return withNewAgentLike(getAgent());
    }

    public V1alpha1PipelineTemplateTaskFluent.AgentNested<A> editOrNewAgent(){
            return withNewAgentLike(getAgent() != null ? getAgent(): new V1alpha1JenkinsAgentBuilder().build());
    }

    public V1alpha1PipelineTemplateTaskFluent.AgentNested<A> editOrNewAgentLike(V1alpha1JenkinsAgent item){
            return withNewAgentLike(getAgent() != null ? getAgent(): item);
    }

    
/**
 * This method has been deprecated, please use method buildApprove instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTaskApprove getApprove(){
            return this.approve!=null?this.approve.build():null;
    }

    public V1alpha1PipelineTaskApprove buildApprove(){
            return this.approve!=null?this.approve.build():null;
    }

    public A withApprove(V1alpha1PipelineTaskApprove approve){
            _visitables.get("approve").remove(this.approve);
            if (approve!=null){ this.approve= new V1alpha1PipelineTaskApproveBuilder(approve); _visitables.get("approve").add(this.approve);} return (A) this;
    }

    public Boolean hasApprove(){
            return this.approve != null;
    }

    public V1alpha1PipelineTemplateTaskFluent.ApproveNested<A> withNewApprove(){
            return new ApproveNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskFluent.ApproveNested<A> withNewApproveLike(V1alpha1PipelineTaskApprove item){
            return new ApproveNestedImpl(item);
    }

    public V1alpha1PipelineTemplateTaskFluent.ApproveNested<A> editApprove(){
            return withNewApproveLike(getApprove());
    }

    public V1alpha1PipelineTemplateTaskFluent.ApproveNested<A> editOrNewApprove(){
            return withNewApproveLike(getApprove() != null ? getApprove(): new V1alpha1PipelineTaskApproveBuilder().build());
    }

    public V1alpha1PipelineTemplateTaskFluent.ApproveNested<A> editOrNewApproveLike(V1alpha1PipelineTaskApprove item){
            return withNewApproveLike(getApprove() != null ? getApprove(): item);
    }

    public A addToConditions(String key,List<String> value){
            if(this.conditions == null && key != null && value != null) { this.conditions = new LinkedHashMap<String,List<String>>(); }
            if(key != null && value != null) {this.conditions.put(key, value);} return (A)this;
    }

    public A addToConditions(Map<String,List<String>> map){
            if(this.conditions == null && map != null) { this.conditions = new LinkedHashMap<String,List<String>>(); }
            if(map != null) { this.conditions.putAll(map);} return (A)this;
    }

    public A removeFromConditions(String key){
            if(this.conditions == null) { return (A) this; }
            if(key != null && this.conditions != null) {this.conditions.remove(key);} return (A)this;
    }

    public A removeFromConditions(Map<String,List<String>> map){
            if(this.conditions == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.conditions != null){this.conditions.remove(key);}}} return (A)this;
    }

    public Map<String,List<String>> getConditions(){
            return this.conditions;
    }

    public A withConditions(Map<String,List<String>> conditions){
            if (conditions == null) { this.conditions =  null;} else {this.conditions = new LinkedHashMap<String,List<String>>(conditions);} return (A) this;
    }

    public Boolean hasConditions(){
            return this.conditions != null;
    }

    
/**
 * This method has been deprecated, please use method buildDisplay instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1I18nName getDisplay(){
            return this.display!=null?this.display.build():null;
    }

    public V1alpha1I18nName buildDisplay(){
            return this.display!=null?this.display.build():null;
    }

    public A withDisplay(V1alpha1I18nName display){
            _visitables.get("display").remove(this.display);
            if (display!=null){ this.display= new V1alpha1I18nNameBuilder(display); _visitables.get("display").add(this.display);} return (A) this;
    }

    public Boolean hasDisplay(){
            return this.display != null;
    }

    public V1alpha1PipelineTemplateTaskFluent.DisplayNested<A> withNewDisplay(){
            return new DisplayNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskFluent.DisplayNested<A> withNewDisplayLike(V1alpha1I18nName item){
            return new DisplayNestedImpl(item);
    }

    public V1alpha1PipelineTemplateTaskFluent.DisplayNested<A> editDisplay(){
            return withNewDisplayLike(getDisplay());
    }

    public V1alpha1PipelineTemplateTaskFluent.DisplayNested<A> editOrNewDisplay(){
            return withNewDisplayLike(getDisplay() != null ? getDisplay(): new V1alpha1I18nNameBuilder().build());
    }

    public V1alpha1PipelineTemplateTaskFluent.DisplayNested<A> editOrNewDisplayLike(V1alpha1I18nName item){
            return withNewDisplayLike(getDisplay() != null ? getDisplay(): item);
    }

    public A addToEnvironments(int index,V1alpha1PipelineEnvironment item){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(index >= 0 ? index : _visitables.get("environments").size(), builder);this.environments.add(index >= 0 ? index : environments.size(), builder); return (A)this;
    }

    public A setToEnvironments(int index,V1alpha1PipelineEnvironment item){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);
            if (index < 0 || index >= _visitables.get("environments").size()) { _visitables.get("environments").add(builder); } else { _visitables.get("environments").set(index, builder);}
            if (index < 0 || index >= environments.size()) { environments.add(builder); } else { environments.set(index, builder);}
             return (A)this;
    }

    public A addToEnvironments(V1alpha1PipelineEnvironment... items){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(builder);this.environments.add(builder);} return (A)this;
    }

    public A addAllToEnvironments(Collection<V1alpha1PipelineEnvironment> items){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(builder);this.environments.add(builder);} return (A)this;
    }

    public A removeFromEnvironments(V1alpha1PipelineEnvironment... items){
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").remove(builder);if (this.environments != null) {this.environments.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnvironments(Collection<V1alpha1PipelineEnvironment> items){
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").remove(builder);if (this.environments != null) {this.environments.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnvironments instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineEnvironment> getEnvironments(){
            return build(environments);
    }

    public List<V1alpha1PipelineEnvironment> buildEnvironments(){
            return build(environments);
    }

    public V1alpha1PipelineEnvironment buildEnvironment(int index){
            return this.environments.get(index).build();
    }

    public V1alpha1PipelineEnvironment buildFirstEnvironment(){
            return this.environments.get(0).build();
    }

    public V1alpha1PipelineEnvironment buildLastEnvironment(){
            return this.environments.get(environments.size() - 1).build();
    }

    public V1alpha1PipelineEnvironment buildMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            for (V1alpha1PipelineEnvironmentBuilder item: environments) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            for (V1alpha1PipelineEnvironmentBuilder item: environments) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withEnvironments(List<V1alpha1PipelineEnvironment> environments){
            if (this.environments != null) { _visitables.get("environments").removeAll(this.environments);}
            if (environments != null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>(); for (V1alpha1PipelineEnvironment item : environments){this.addToEnvironments(item);}} else { this.environments = null;} return (A) this;
    }

    public A withEnvironments(V1alpha1PipelineEnvironment... environments){
            if (this.environments != null) {this.environments.clear();}
            if (environments != null) {for (V1alpha1PipelineEnvironment item :environments){ this.addToEnvironments(item);}} return (A) this;
    }

    public Boolean hasEnvironments(){
            return environments != null && !environments.isEmpty();
    }

    public V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<A> addNewEnvironment(){
            return new EnvironmentsNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<A> addNewEnvironmentLike(V1alpha1PipelineEnvironment item){
            return new EnvironmentsNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<A> setNewEnvironmentLike(int index,V1alpha1PipelineEnvironment item){
            return new EnvironmentsNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<A> editEnvironment(int index){
            if (environments.size() <= index) throw new RuntimeException("Can't edit environments. Index exceeds size.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<A> editFirstEnvironment(){
            if (environments.size() == 0) throw new RuntimeException("Can't edit first environments. The list is empty.");
            return setNewEnvironmentLike(0, buildEnvironment(0));
    }

    public V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<A> editLastEnvironment(){
            int index = environments.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last environments. The list is empty.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<A> editMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            int index = -1;
            for (int i=0;i<environments.size();i++) { 
            if (predicate.apply(environments.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching environments. No match found.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildOptions instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTaskOption getOptions(){
            return this.options!=null?this.options.build():null;
    }

    public V1alpha1PipelineTaskOption buildOptions(){
            return this.options!=null?this.options.build():null;
    }

    public A withOptions(V1alpha1PipelineTaskOption options){
            _visitables.get("options").remove(this.options);
            if (options!=null){ this.options= new V1alpha1PipelineTaskOptionBuilder(options); _visitables.get("options").add(this.options);} return (A) this;
    }

    public Boolean hasOptions(){
            return this.options != null;
    }

    public V1alpha1PipelineTemplateTaskFluent.OptionsNested<A> withNewOptions(){
            return new OptionsNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskFluent.OptionsNested<A> withNewOptionsLike(V1alpha1PipelineTaskOption item){
            return new OptionsNestedImpl(item);
    }

    public V1alpha1PipelineTemplateTaskFluent.OptionsNested<A> editOptions(){
            return withNewOptionsLike(getOptions());
    }

    public V1alpha1PipelineTemplateTaskFluent.OptionsNested<A> editOrNewOptions(){
            return withNewOptionsLike(getOptions() != null ? getOptions(): new V1alpha1PipelineTaskOptionBuilder().build());
    }

    public V1alpha1PipelineTemplateTaskFluent.OptionsNested<A> editOrNewOptionsLike(V1alpha1PipelineTaskOption item){
            return withNewOptionsLike(getOptions() != null ? getOptions(): item);
    }

    public A addToRelation(int index,V1alpha1PipelineTaskArgumentAction item){
            if (this.relation == null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>();}
            V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").add(index >= 0 ? index : _visitables.get("relation").size(), builder);this.relation.add(index >= 0 ? index : relation.size(), builder); return (A)this;
    }

    public A setToRelation(int index,V1alpha1PipelineTaskArgumentAction item){
            if (this.relation == null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>();}
            V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);
            if (index < 0 || index >= _visitables.get("relation").size()) { _visitables.get("relation").add(builder); } else { _visitables.get("relation").set(index, builder);}
            if (index < 0 || index >= relation.size()) { relation.add(builder); } else { relation.set(index, builder);}
             return (A)this;
    }

    public A addToRelation(V1alpha1PipelineTaskArgumentAction... items){
            if (this.relation == null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>();}
            for (V1alpha1PipelineTaskArgumentAction item : items) {V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").add(builder);this.relation.add(builder);} return (A)this;
    }

    public A addAllToRelation(Collection<V1alpha1PipelineTaskArgumentAction> items){
            if (this.relation == null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>();}
            for (V1alpha1PipelineTaskArgumentAction item : items) {V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").add(builder);this.relation.add(builder);} return (A)this;
    }

    public A removeFromRelation(V1alpha1PipelineTaskArgumentAction... items){
            for (V1alpha1PipelineTaskArgumentAction item : items) {V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").remove(builder);if (this.relation != null) {this.relation.remove(builder);}} return (A)this;
    }

    public A removeAllFromRelation(Collection<V1alpha1PipelineTaskArgumentAction> items){
            for (V1alpha1PipelineTaskArgumentAction item : items) {V1alpha1PipelineTaskArgumentActionBuilder builder = new V1alpha1PipelineTaskArgumentActionBuilder(item);_visitables.get("relation").remove(builder);if (this.relation != null) {this.relation.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRelation instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineTaskArgumentAction> getRelation(){
            return build(relation);
    }

    public List<V1alpha1PipelineTaskArgumentAction> buildRelation(){
            return build(relation);
    }

    public V1alpha1PipelineTaskArgumentAction buildRelation(int index){
            return this.relation.get(index).build();
    }

    public V1alpha1PipelineTaskArgumentAction buildFirstRelation(){
            return this.relation.get(0).build();
    }

    public V1alpha1PipelineTaskArgumentAction buildLastRelation(){
            return this.relation.get(relation.size() - 1).build();
    }

    public V1alpha1PipelineTaskArgumentAction buildMatchingRelation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTaskArgumentActionBuilder> predicate){
            for (V1alpha1PipelineTaskArgumentActionBuilder item: relation) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingRelation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTaskArgumentActionBuilder> predicate){
            for (V1alpha1PipelineTaskArgumentActionBuilder item: relation) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withRelation(List<V1alpha1PipelineTaskArgumentAction> relation){
            if (this.relation != null) { _visitables.get("relation").removeAll(this.relation);}
            if (relation != null) {this.relation = new ArrayList<V1alpha1PipelineTaskArgumentActionBuilder>(); for (V1alpha1PipelineTaskArgumentAction item : relation){this.addToRelation(item);}} else { this.relation = null;} return (A) this;
    }

    public A withRelation(V1alpha1PipelineTaskArgumentAction... relation){
            if (this.relation != null) {this.relation.clear();}
            if (relation != null) {for (V1alpha1PipelineTaskArgumentAction item :relation){ this.addToRelation(item);}} return (A) this;
    }

    public Boolean hasRelation(){
            return relation != null && !relation.isEmpty();
    }

    public V1alpha1PipelineTemplateTaskFluent.RelationNested<A> addNewRelation(){
            return new RelationNestedImpl();
    }

    public V1alpha1PipelineTemplateTaskFluent.RelationNested<A> addNewRelationLike(V1alpha1PipelineTaskArgumentAction item){
            return new RelationNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateTaskFluent.RelationNested<A> setNewRelationLike(int index,V1alpha1PipelineTaskArgumentAction item){
            return new RelationNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateTaskFluent.RelationNested<A> editRelation(int index){
            if (relation.size() <= index) throw new RuntimeException("Can't edit relation. Index exceeds size.");
            return setNewRelationLike(index, buildRelation(index));
    }

    public V1alpha1PipelineTemplateTaskFluent.RelationNested<A> editFirstRelation(){
            if (relation.size() == 0) throw new RuntimeException("Can't edit first relation. The list is empty.");
            return setNewRelationLike(0, buildRelation(0));
    }

    public V1alpha1PipelineTemplateTaskFluent.RelationNested<A> editLastRelation(){
            int index = relation.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last relation. The list is empty.");
            return setNewRelationLike(index, buildRelation(index));
    }

    public V1alpha1PipelineTemplateTaskFluent.RelationNested<A> editMatchingRelation(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTaskArgumentActionBuilder> predicate){
            int index = -1;
            for (int i=0;i<relation.size();i++) { 
            if (predicate.apply(relation.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching relation. No match found.");
            return setNewRelationLike(index, buildRelation(index));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateTaskFluentImpl that = (V1alpha1PipelineTemplateTaskFluentImpl) o;
            if (agent != null ? !agent.equals(that.agent) :that.agent != null) return false;
            if (approve != null ? !approve.equals(that.approve) :that.approve != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (display != null ? !display.equals(that.display) :that.display != null) return false;
            if (environments != null ? !environments.equals(that.environments) :that.environments != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (options != null ? !options.equals(that.options) :that.options != null) return false;
            if (relation != null ? !relation.equals(that.relation) :that.relation != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class AgentNestedImpl<N> extends V1alpha1JenkinsAgentFluentImpl<V1alpha1PipelineTemplateTaskFluent.AgentNested<N>> implements V1alpha1PipelineTemplateTaskFluent.AgentNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1JenkinsAgentBuilder builder;
    
            AgentNestedImpl(V1alpha1JenkinsAgent item){
                    this.builder = new V1alpha1JenkinsAgentBuilder(this, item);
            }
            AgentNestedImpl(){
                    this.builder = new V1alpha1JenkinsAgentBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskFluentImpl.this.withAgent(builder.build());
    }
    public N endAgent(){
            return and();
    }

}
    public class ApproveNestedImpl<N> extends V1alpha1PipelineTaskApproveFluentImpl<V1alpha1PipelineTemplateTaskFluent.ApproveNested<N>> implements V1alpha1PipelineTemplateTaskFluent.ApproveNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTaskApproveBuilder builder;
    
            ApproveNestedImpl(V1alpha1PipelineTaskApprove item){
                    this.builder = new V1alpha1PipelineTaskApproveBuilder(this, item);
            }
            ApproveNestedImpl(){
                    this.builder = new V1alpha1PipelineTaskApproveBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskFluentImpl.this.withApprove(builder.build());
    }
    public N endApprove(){
            return and();
    }

}
    public class DisplayNestedImpl<N> extends V1alpha1I18nNameFluentImpl<V1alpha1PipelineTemplateTaskFluent.DisplayNested<N>> implements V1alpha1PipelineTemplateTaskFluent.DisplayNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1I18nNameBuilder builder;
    
            DisplayNestedImpl(V1alpha1I18nName item){
                    this.builder = new V1alpha1I18nNameBuilder(this, item);
            }
            DisplayNestedImpl(){
                    this.builder = new V1alpha1I18nNameBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskFluentImpl.this.withDisplay(builder.build());
    }
    public N endDisplay(){
            return and();
    }

}
    public class EnvironmentsNestedImpl<N> extends V1alpha1PipelineEnvironmentFluentImpl<V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<N>> implements V1alpha1PipelineTemplateTaskFluent.EnvironmentsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineEnvironmentBuilder builder;
        private final int index;
    
            EnvironmentsNestedImpl(int index,V1alpha1PipelineEnvironment item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineEnvironmentBuilder(this, item);
            }
            EnvironmentsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineEnvironmentBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskFluentImpl.this.setToEnvironments(index, builder.build());
    }
    public N endEnvironment(){
            return and();
    }

}
    public class OptionsNestedImpl<N> extends V1alpha1PipelineTaskOptionFluentImpl<V1alpha1PipelineTemplateTaskFluent.OptionsNested<N>> implements V1alpha1PipelineTemplateTaskFluent.OptionsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTaskOptionBuilder builder;
    
            OptionsNestedImpl(V1alpha1PipelineTaskOption item){
                    this.builder = new V1alpha1PipelineTaskOptionBuilder(this, item);
            }
            OptionsNestedImpl(){
                    this.builder = new V1alpha1PipelineTaskOptionBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskFluentImpl.this.withOptions(builder.build());
    }
    public N endOptions(){
            return and();
    }

}
    public class RelationNestedImpl<N> extends V1alpha1PipelineTaskArgumentActionFluentImpl<V1alpha1PipelineTemplateTaskFluent.RelationNested<N>> implements V1alpha1PipelineTemplateTaskFluent.RelationNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTaskArgumentActionBuilder builder;
        private final int index;
    
            RelationNestedImpl(int index,V1alpha1PipelineTaskArgumentAction item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineTaskArgumentActionBuilder(this, item);
            }
            RelationNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineTaskArgumentActionBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateTaskFluentImpl.this.setToRelation(index, builder.build());
    }
    public N endRelation(){
            return and();
    }

}


}
