package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateArgumentBuilder extends V1alpha1PipelineTemplateArgumentFluentImpl<V1alpha1PipelineTemplateArgumentBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateArgument,V1alpha1PipelineTemplateArgumentBuilder>{

    V1alpha1PipelineTemplateArgumentFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateArgumentBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateArgumentBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateArgument(), validationEnabled);
    }
    public V1alpha1PipelineTemplateArgumentBuilder(V1alpha1PipelineTemplateArgumentFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateArgumentBuilder(V1alpha1PipelineTemplateArgumentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateArgument(), validationEnabled);
    }
    public V1alpha1PipelineTemplateArgumentBuilder(V1alpha1PipelineTemplateArgumentFluent<?> fluent,V1alpha1PipelineTemplateArgument instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateArgumentBuilder(V1alpha1PipelineTemplateArgumentFluent<?> fluent,V1alpha1PipelineTemplateArgument instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBinding(instance.getBinding());

            fluent.withDefault(instance.getDefault());

            fluent.withDisplay(instance.getDisplay());

            fluent.withName(instance.getName());

            fluent.withRelation(instance.getRelation());

            fluent.withRequired(instance.isRequired());

            fluent.withSchema(instance.getSchema());

            fluent.withValidation(instance.getValidation());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateArgumentBuilder(V1alpha1PipelineTemplateArgument instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateArgumentBuilder(V1alpha1PipelineTemplateArgument instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBinding(instance.getBinding());

            this.withDefault(instance.getDefault());

            this.withDisplay(instance.getDisplay());

            this.withName(instance.getName());

            this.withRelation(instance.getRelation());

            this.withRequired(instance.isRequired());

            this.withSchema(instance.getSchema());

            this.withValidation(instance.getValidation());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateArgument build(){
            V1alpha1PipelineTemplateArgument buildable = new V1alpha1PipelineTemplateArgument();
            buildable.setBinding(fluent.getBinding());
            buildable.setDefault(fluent.getDefault());
            buildable.setDisplay(fluent.getDisplay());
            buildable.setName(fluent.getName());
            buildable.setRelation(fluent.getRelation());
            buildable.setRequired(fluent.isRequired());
            buildable.setSchema(fluent.getSchema());
            buildable.setValidation(fluent.getValidation());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateArgumentBuilder that = (V1alpha1PipelineTemplateArgumentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
