package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskApproveBuilder extends V1alpha1PipelineTaskApproveFluentImpl<V1alpha1PipelineTaskApproveBuilder> implements VisitableBuilder<V1alpha1PipelineTaskApprove,V1alpha1PipelineTaskApproveBuilder>{

    V1alpha1PipelineTaskApproveFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskApproveBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskApproveBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTaskApprove(), validationEnabled);
    }
    public V1alpha1PipelineTaskApproveBuilder(V1alpha1PipelineTaskApproveFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskApproveBuilder(V1alpha1PipelineTaskApproveFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTaskApprove(), validationEnabled);
    }
    public V1alpha1PipelineTaskApproveBuilder(V1alpha1PipelineTaskApproveFluent<?> fluent,V1alpha1PipelineTaskApprove instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskApproveBuilder(V1alpha1PipelineTaskApproveFluent<?> fluent,V1alpha1PipelineTaskApprove instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMessage(instance.getMessage());

            fluent.withTimeout(instance.getTimeout());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskApproveBuilder(V1alpha1PipelineTaskApprove instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskApproveBuilder(V1alpha1PipelineTaskApprove instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMessage(instance.getMessage());

            this.withTimeout(instance.getTimeout());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTaskApprove build(){
            V1alpha1PipelineTaskApprove buildable = new V1alpha1PipelineTaskApprove();
            buildable.setMessage(fluent.getMessage());
            buildable.setTimeout(fluent.getTimeout());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskApproveBuilder that = (V1alpha1PipelineTaskApproveBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
