package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStageInstanceBuilder extends V1alpha1PipelineStageInstanceFluentImpl<V1alpha1PipelineStageInstanceBuilder> implements VisitableBuilder<V1alpha1PipelineStageInstance,V1alpha1PipelineStageInstanceBuilder>{

    V1alpha1PipelineStageInstanceFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineStageInstanceBuilder(){
            this(true);
    }
    public V1alpha1PipelineStageInstanceBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineStageInstance(), validationEnabled);
    }
    public V1alpha1PipelineStageInstanceBuilder(V1alpha1PipelineStageInstanceFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineStageInstanceBuilder(V1alpha1PipelineStageInstanceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineStageInstance(), validationEnabled);
    }
    public V1alpha1PipelineStageInstanceBuilder(V1alpha1PipelineStageInstanceFluent<?> fluent,V1alpha1PipelineStageInstance instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineStageInstanceBuilder(V1alpha1PipelineStageInstanceFluent<?> fluent,V1alpha1PipelineStageInstance instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withTasks(instance.getTasks());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineStageInstanceBuilder(V1alpha1PipelineStageInstance instance){
            this(instance,true);
    }
    public V1alpha1PipelineStageInstanceBuilder(V1alpha1PipelineStageInstance instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withTasks(instance.getTasks());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineStageInstance build(){
            V1alpha1PipelineStageInstance buildable = new V1alpha1PipelineStageInstance();
            buildable.setName(fluent.getName());
            buildable.setTasks(fluent.getTasks());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStageInstanceBuilder that = (V1alpha1PipelineStageInstanceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
