package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineDependencyBuilder extends V1alpha1PipelineDependencyFluentImpl<V1alpha1PipelineDependencyBuilder> implements VisitableBuilder<V1alpha1PipelineDependency,V1alpha1PipelineDependencyBuilder>{

    V1alpha1PipelineDependencyFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineDependencyBuilder(){
            this(true);
    }
    public V1alpha1PipelineDependencyBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineDependency(), validationEnabled);
    }
    public V1alpha1PipelineDependencyBuilder(V1alpha1PipelineDependencyFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineDependencyBuilder(V1alpha1PipelineDependencyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineDependency(), validationEnabled);
    }
    public V1alpha1PipelineDependencyBuilder(V1alpha1PipelineDependencyFluent<?> fluent,V1alpha1PipelineDependency instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineDependencyBuilder(V1alpha1PipelineDependencyFluent<?> fluent,V1alpha1PipelineDependency instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPlugins(instance.getPlugins());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineDependencyBuilder(V1alpha1PipelineDependency instance){
            this(instance,true);
    }
    public V1alpha1PipelineDependencyBuilder(V1alpha1PipelineDependency instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPlugins(instance.getPlugins());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineDependency build(){
            V1alpha1PipelineDependency buildable = new V1alpha1PipelineDependency();
            buildable.setPlugins(fluent.getPlugins());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineDependencyBuilder that = (V1alpha1PipelineDependencyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
