package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineConfigLogBuilder extends V1alpha1PipelineConfigLogFluentImpl<V1alpha1PipelineConfigLogBuilder> implements VisitableBuilder<V1alpha1PipelineConfigLog,V1alpha1PipelineConfigLogBuilder>{

    V1alpha1PipelineConfigLogFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineConfigLogBuilder(){
            this(true);
    }
    public V1alpha1PipelineConfigLogBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineConfigLog(), validationEnabled);
    }
    public V1alpha1PipelineConfigLogBuilder(V1alpha1PipelineConfigLogFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineConfigLogBuilder(V1alpha1PipelineConfigLogFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineConfigLog(), validationEnabled);
    }
    public V1alpha1PipelineConfigLogBuilder(V1alpha1PipelineConfigLogFluent<?> fluent,V1alpha1PipelineConfigLog instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineConfigLogBuilder(V1alpha1PipelineConfigLogFluent<?> fluent,V1alpha1PipelineConfigLog instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMore(instance.isMore());

            fluent.withNextStart(instance.getNextStart());

            fluent.withText(instance.getText());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineConfigLogBuilder(V1alpha1PipelineConfigLog instance){
            this(instance,true);
    }
    public V1alpha1PipelineConfigLogBuilder(V1alpha1PipelineConfigLog instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMore(instance.isMore());

            this.withNextStart(instance.getNextStart());

            this.withText(instance.getText());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineConfigLog build(){
            V1alpha1PipelineConfigLog buildable = new V1alpha1PipelineConfigLog();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMore(fluent.isMore());
            buildable.setNextStart(fluent.getNextStart());
            buildable.setText(fluent.getText());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineConfigLogBuilder that = (V1alpha1PipelineConfigLogBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
