package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsStatusBuilder extends V1alpha1JenkinsStatusFluentImpl<V1alpha1JenkinsStatusBuilder> implements VisitableBuilder<V1alpha1JenkinsStatus,V1alpha1JenkinsStatusBuilder>{

    V1alpha1JenkinsStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1JenkinsStatusBuilder(){
            this(true);
    }
    public V1alpha1JenkinsStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1JenkinsStatus(), validationEnabled);
    }
    public V1alpha1JenkinsStatusBuilder(V1alpha1JenkinsStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1JenkinsStatusBuilder(V1alpha1JenkinsStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1JenkinsStatus(), validationEnabled);
    }
    public V1alpha1JenkinsStatusBuilder(V1alpha1JenkinsStatusFluent<?> fluent,V1alpha1JenkinsStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1JenkinsStatusBuilder(V1alpha1JenkinsStatusFluent<?> fluent,V1alpha1JenkinsStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withServiceStatus(instance.getServiceStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1JenkinsStatusBuilder(V1alpha1JenkinsStatus instance){
            this(instance,true);
    }
    public V1alpha1JenkinsStatusBuilder(V1alpha1JenkinsStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withServiceStatus(instance.getServiceStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1JenkinsStatus build(){
            V1alpha1JenkinsStatus buildable = new V1alpha1JenkinsStatus();
            buildable.setServiceStatus(fluent.getServiceStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsStatusBuilder that = (V1alpha1JenkinsStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
