package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageTagBuilder extends V1alpha1ImageTagFluentImpl<V1alpha1ImageTagBuilder> implements VisitableBuilder<V1alpha1ImageTag,V1alpha1ImageTagBuilder>{

    V1alpha1ImageTagFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageTagBuilder(){
            this(true);
    }
    public V1alpha1ImageTagBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageTag(), validationEnabled);
    }
    public V1alpha1ImageTagBuilder(V1alpha1ImageTagFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageTagBuilder(V1alpha1ImageTagFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageTag(), validationEnabled);
    }
    public V1alpha1ImageTagBuilder(V1alpha1ImageTagFluent<?> fluent,V1alpha1ImageTag instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageTagBuilder(V1alpha1ImageTagFluent<?> fluent,V1alpha1ImageTag instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuthor(instance.getAuthor());

            fluent.withCreatedAt(instance.getCreatedAt());

            fluent.withDigest(instance.getDigest());

            fluent.withLevel(instance.getLevel());

            fluent.withMessage(instance.getMessage());

            fluent.withName(instance.getName());

            fluent.withScanStatus(instance.getScanStatus());

            fluent.withSize(instance.getSize());

            fluent.withSummary(instance.getSummary());

            fluent.withUpdatedAt(instance.getUpdatedAt());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageTagBuilder(V1alpha1ImageTag instance){
            this(instance,true);
    }
    public V1alpha1ImageTagBuilder(V1alpha1ImageTag instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuthor(instance.getAuthor());

            this.withCreatedAt(instance.getCreatedAt());

            this.withDigest(instance.getDigest());

            this.withLevel(instance.getLevel());

            this.withMessage(instance.getMessage());

            this.withName(instance.getName());

            this.withScanStatus(instance.getScanStatus());

            this.withSize(instance.getSize());

            this.withSummary(instance.getSummary());

            this.withUpdatedAt(instance.getUpdatedAt());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageTag build(){
            V1alpha1ImageTag buildable = new V1alpha1ImageTag();
            buildable.setAuthor(fluent.getAuthor());
            buildable.setCreatedAt(fluent.getCreatedAt());
            buildable.setDigest(fluent.getDigest());
            buildable.setLevel(fluent.getLevel());
            buildable.setMessage(fluent.getMessage());
            buildable.setName(fluent.getName());
            buildable.setScanStatus(fluent.getScanStatus());
            buildable.setSize(fluent.getSize());
            buildable.setSummary(fluent.getSummary());
            buildable.setUpdatedAt(fluent.getUpdatedAt());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageTagBuilder that = (V1alpha1ImageTagBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
