package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1ImageRepositoryStatusFluentImpl<A extends V1alpha1ImageRepositoryStatusFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1ImageRepositoryStatusFluent<A>{

    private V1alpha1ServiceStatusBuilder serviceStatus;
    private V1alpha1ImageTagBuilder latestTag;
    private List<V1alpha1ImageTagBuilder> tags;

    public V1alpha1ImageRepositoryStatusFluentImpl(){
    }
    public V1alpha1ImageRepositoryStatusFluentImpl(V1alpha1ImageRepositoryStatus instance){
            this.withServiceStatus(instance.getServiceStatus());

            this.withLatestTag(instance.getLatestTag());

            this.withTags(instance.getTags());

    }

    
/**
 * This method has been deprecated, please use method buildServiceStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ServiceStatus getServiceStatus(){
            return this.serviceStatus!=null?this.serviceStatus.build():null;
    }

    public V1alpha1ServiceStatus buildServiceStatus(){
            return this.serviceStatus!=null?this.serviceStatus.build():null;
    }

    public A withServiceStatus(V1alpha1ServiceStatus serviceStatus){
            _visitables.get("serviceStatus").remove(this.serviceStatus);
            if (serviceStatus!=null){ this.serviceStatus= new V1alpha1ServiceStatusBuilder(serviceStatus); _visitables.get("serviceStatus").add(this.serviceStatus);} return (A) this;
    }

    public Boolean hasServiceStatus(){
            return this.serviceStatus != null;
    }

    public V1alpha1ImageRepositoryStatusFluent.ServiceStatusNested<A> withNewServiceStatus(){
            return new ServiceStatusNestedImpl();
    }

    public V1alpha1ImageRepositoryStatusFluent.ServiceStatusNested<A> withNewServiceStatusLike(V1alpha1ServiceStatus item){
            return new ServiceStatusNestedImpl(item);
    }

    public V1alpha1ImageRepositoryStatusFluent.ServiceStatusNested<A> editServiceStatus(){
            return withNewServiceStatusLike(getServiceStatus());
    }

    public V1alpha1ImageRepositoryStatusFluent.ServiceStatusNested<A> editOrNewServiceStatus(){
            return withNewServiceStatusLike(getServiceStatus() != null ? getServiceStatus(): new V1alpha1ServiceStatusBuilder().build());
    }

    public V1alpha1ImageRepositoryStatusFluent.ServiceStatusNested<A> editOrNewServiceStatusLike(V1alpha1ServiceStatus item){
            return withNewServiceStatusLike(getServiceStatus() != null ? getServiceStatus(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLatestTag instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ImageTag getLatestTag(){
            return this.latestTag!=null?this.latestTag.build():null;
    }

    public V1alpha1ImageTag buildLatestTag(){
            return this.latestTag!=null?this.latestTag.build():null;
    }

    public A withLatestTag(V1alpha1ImageTag latestTag){
            _visitables.get("latestTag").remove(this.latestTag);
            if (latestTag!=null){ this.latestTag= new V1alpha1ImageTagBuilder(latestTag); _visitables.get("latestTag").add(this.latestTag);} return (A) this;
    }

    public Boolean hasLatestTag(){
            return this.latestTag != null;
    }

    public V1alpha1ImageRepositoryStatusFluent.LatestTagNested<A> withNewLatestTag(){
            return new LatestTagNestedImpl();
    }

    public V1alpha1ImageRepositoryStatusFluent.LatestTagNested<A> withNewLatestTagLike(V1alpha1ImageTag item){
            return new LatestTagNestedImpl(item);
    }

    public V1alpha1ImageRepositoryStatusFluent.LatestTagNested<A> editLatestTag(){
            return withNewLatestTagLike(getLatestTag());
    }

    public V1alpha1ImageRepositoryStatusFluent.LatestTagNested<A> editOrNewLatestTag(){
            return withNewLatestTagLike(getLatestTag() != null ? getLatestTag(): new V1alpha1ImageTagBuilder().build());
    }

    public V1alpha1ImageRepositoryStatusFluent.LatestTagNested<A> editOrNewLatestTagLike(V1alpha1ImageTag item){
            return withNewLatestTagLike(getLatestTag() != null ? getLatestTag(): item);
    }

    public A addToTags(int index,V1alpha1ImageTag item){
            if (this.tags == null) {this.tags = new ArrayList<V1alpha1ImageTagBuilder>();}
            V1alpha1ImageTagBuilder builder = new V1alpha1ImageTagBuilder(item);_visitables.get("tags").add(index >= 0 ? index : _visitables.get("tags").size(), builder);this.tags.add(index >= 0 ? index : tags.size(), builder); return (A)this;
    }

    public A setToTags(int index,V1alpha1ImageTag item){
            if (this.tags == null) {this.tags = new ArrayList<V1alpha1ImageTagBuilder>();}
            V1alpha1ImageTagBuilder builder = new V1alpha1ImageTagBuilder(item);
            if (index < 0 || index >= _visitables.get("tags").size()) { _visitables.get("tags").add(builder); } else { _visitables.get("tags").set(index, builder);}
            if (index < 0 || index >= tags.size()) { tags.add(builder); } else { tags.set(index, builder);}
             return (A)this;
    }

    public A addToTags(V1alpha1ImageTag... items){
            if (this.tags == null) {this.tags = new ArrayList<V1alpha1ImageTagBuilder>();}
            for (V1alpha1ImageTag item : items) {V1alpha1ImageTagBuilder builder = new V1alpha1ImageTagBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
    }

    public A addAllToTags(Collection<V1alpha1ImageTag> items){
            if (this.tags == null) {this.tags = new ArrayList<V1alpha1ImageTagBuilder>();}
            for (V1alpha1ImageTag item : items) {V1alpha1ImageTagBuilder builder = new V1alpha1ImageTagBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
    }

    public A removeFromTags(V1alpha1ImageTag... items){
            for (V1alpha1ImageTag item : items) {V1alpha1ImageTagBuilder builder = new V1alpha1ImageTagBuilder(item);_visitables.get("tags").remove(builder);if (this.tags != null) {this.tags.remove(builder);}} return (A)this;
    }

    public A removeAllFromTags(Collection<V1alpha1ImageTag> items){
            for (V1alpha1ImageTag item : items) {V1alpha1ImageTagBuilder builder = new V1alpha1ImageTagBuilder(item);_visitables.get("tags").remove(builder);if (this.tags != null) {this.tags.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTags instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1ImageTag> getTags(){
            return build(tags);
    }

    public List<V1alpha1ImageTag> buildTags(){
            return build(tags);
    }

    public V1alpha1ImageTag buildTag(int index){
            return this.tags.get(index).build();
    }

    public V1alpha1ImageTag buildFirstTag(){
            return this.tags.get(0).build();
    }

    public V1alpha1ImageTag buildLastTag(){
            return this.tags.get(tags.size() - 1).build();
    }

    public V1alpha1ImageTag buildMatchingTag(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ImageTagBuilder> predicate){
            for (V1alpha1ImageTagBuilder item: tags) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTag(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ImageTagBuilder> predicate){
            for (V1alpha1ImageTagBuilder item: tags) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTags(List<V1alpha1ImageTag> tags){
            if (this.tags != null) { _visitables.get("tags").removeAll(this.tags);}
            if (tags != null) {this.tags = new ArrayList<V1alpha1ImageTagBuilder>(); for (V1alpha1ImageTag item : tags){this.addToTags(item);}} else { this.tags = null;} return (A) this;
    }

    public A withTags(V1alpha1ImageTag... tags){
            if (this.tags != null) {this.tags.clear();}
            if (tags != null) {for (V1alpha1ImageTag item :tags){ this.addToTags(item);}} return (A) this;
    }

    public Boolean hasTags(){
            return tags != null && !tags.isEmpty();
    }

    public V1alpha1ImageRepositoryStatusFluent.TagsNested<A> addNewTag(){
            return new TagsNestedImpl();
    }

    public V1alpha1ImageRepositoryStatusFluent.TagsNested<A> addNewTagLike(V1alpha1ImageTag item){
            return new TagsNestedImpl(-1, item);
    }

    public V1alpha1ImageRepositoryStatusFluent.TagsNested<A> setNewTagLike(int index,V1alpha1ImageTag item){
            return new TagsNestedImpl(index, item);
    }

    public V1alpha1ImageRepositoryStatusFluent.TagsNested<A> editTag(int index){
            if (tags.size() <= index) throw new RuntimeException("Can't edit tags. Index exceeds size.");
            return setNewTagLike(index, buildTag(index));
    }

    public V1alpha1ImageRepositoryStatusFluent.TagsNested<A> editFirstTag(){
            if (tags.size() == 0) throw new RuntimeException("Can't edit first tags. The list is empty.");
            return setNewTagLike(0, buildTag(0));
    }

    public V1alpha1ImageRepositoryStatusFluent.TagsNested<A> editLastTag(){
            int index = tags.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tags. The list is empty.");
            return setNewTagLike(index, buildTag(index));
    }

    public V1alpha1ImageRepositoryStatusFluent.TagsNested<A> editMatchingTag(io.alauda.devops.java.client.fluent.Predicate<V1alpha1ImageTagBuilder> predicate){
            int index = -1;
            for (int i=0;i<tags.size();i++) { 
            if (predicate.apply(tags.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tags. No match found.");
            return setNewTagLike(index, buildTag(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRepositoryStatusFluentImpl that = (V1alpha1ImageRepositoryStatusFluentImpl) o;
            if (serviceStatus != null ? !serviceStatus.equals(that.serviceStatus) :that.serviceStatus != null) return false;
            if (latestTag != null ? !latestTag.equals(that.latestTag) :that.latestTag != null) return false;
            if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
            return true;
    }


    public class ServiceStatusNestedImpl<N> extends V1alpha1ServiceStatusFluentImpl<V1alpha1ImageRepositoryStatusFluent.ServiceStatusNested<N>> implements V1alpha1ImageRepositoryStatusFluent.ServiceStatusNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ServiceStatusBuilder builder;
    
            ServiceStatusNestedImpl(V1alpha1ServiceStatus item){
                    this.builder = new V1alpha1ServiceStatusBuilder(this, item);
            }
            ServiceStatusNestedImpl(){
                    this.builder = new V1alpha1ServiceStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ImageRepositoryStatusFluentImpl.this.withServiceStatus(builder.build());
    }
    public N endServiceStatus(){
            return and();
    }

}
    public class LatestTagNestedImpl<N> extends V1alpha1ImageTagFluentImpl<V1alpha1ImageRepositoryStatusFluent.LatestTagNested<N>> implements V1alpha1ImageRepositoryStatusFluent.LatestTagNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ImageTagBuilder builder;
    
            LatestTagNestedImpl(V1alpha1ImageTag item){
                    this.builder = new V1alpha1ImageTagBuilder(this, item);
            }
            LatestTagNestedImpl(){
                    this.builder = new V1alpha1ImageTagBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ImageRepositoryStatusFluentImpl.this.withLatestTag(builder.build());
    }
    public N endLatestTag(){
            return and();
    }

}
    public class TagsNestedImpl<N> extends V1alpha1ImageTagFluentImpl<V1alpha1ImageRepositoryStatusFluent.TagsNested<N>> implements V1alpha1ImageRepositoryStatusFluent.TagsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ImageTagBuilder builder;
        private final int index;
    
            TagsNestedImpl(int index,V1alpha1ImageTag item){
                    this.index = index;
                    this.builder = new V1alpha1ImageTagBuilder(this, item);
            }
            TagsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1ImageTagBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ImageRepositoryStatusFluentImpl.this.setToTags(index, builder.build());
    }
    public N endTag(){
            return and();
    }

}


}
