package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.lang.String;
import org.joda.time.DateTime;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1HostPortStatusFluentImpl<A extends V1alpha1HostPortStatusFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1HostPortStatusFluent<A>{

    private Long delay;
    private String errorMessage;
    private DateTime lastAttempt;
    private String response;
    private Integer statusCode;
    private String version;

    public V1alpha1HostPortStatusFluentImpl(){
    }
    public V1alpha1HostPortStatusFluentImpl(V1alpha1HostPortStatus instance){
            this.withDelay(instance.getDelay());

            this.withErrorMessage(instance.getErrorMessage());

            this.withLastAttempt(instance.getLastAttempt());

            this.withResponse(instance.getResponse());

            this.withStatusCode(instance.getStatusCode());

            this.withVersion(instance.getVersion());

    }

    public Long getDelay(){
            return this.delay;
    }

    public A withDelay(Long delay){
            this.delay=delay; return (A) this;
    }

    public Boolean hasDelay(){
            return this.delay != null;
    }

    public String getErrorMessage(){
            return this.errorMessage;
    }

    public A withErrorMessage(String errorMessage){
            this.errorMessage=errorMessage; return (A) this;
    }

    public Boolean hasErrorMessage(){
            return this.errorMessage != null;
    }

    public A withNewErrorMessage(String arg1){
            return (A)withErrorMessage(new String(arg1));
    }

    public A withNewErrorMessage(StringBuilder arg1){
            return (A)withErrorMessage(new String(arg1));
    }

    public A withNewErrorMessage(StringBuffer arg1){
            return (A)withErrorMessage(new String(arg1));
    }

    public DateTime getLastAttempt(){
            return this.lastAttempt;
    }

    public A withLastAttempt(DateTime lastAttempt){
            this.lastAttempt=lastAttempt; return (A) this;
    }

    public Boolean hasLastAttempt(){
            return this.lastAttempt != null;
    }

    public A withNewLastAttempt(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastAttempt(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastAttempt(Object arg0){
            return (A)withLastAttempt(new DateTime(arg0));
    }

    public A withNewLastAttempt(long arg0){
            return (A)withLastAttempt(new DateTime(arg0));
    }

    public String getResponse(){
            return this.response;
    }

    public A withResponse(String response){
            this.response=response; return (A) this;
    }

    public Boolean hasResponse(){
            return this.response != null;
    }

    public A withNewResponse(String arg1){
            return (A)withResponse(new String(arg1));
    }

    public A withNewResponse(StringBuilder arg1){
            return (A)withResponse(new String(arg1));
    }

    public A withNewResponse(StringBuffer arg1){
            return (A)withResponse(new String(arg1));
    }

    public Integer getStatusCode(){
            return this.statusCode;
    }

    public A withStatusCode(Integer statusCode){
            this.statusCode=statusCode; return (A) this;
    }

    public Boolean hasStatusCode(){
            return this.statusCode != null;
    }

    public String getVersion(){
            return this.version;
    }

    public A withVersion(String version){
            this.version=version; return (A) this;
    }

    public Boolean hasVersion(){
            return this.version != null;
    }

    public A withNewVersion(String arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1){
            return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1HostPortStatusFluentImpl that = (V1alpha1HostPortStatusFluentImpl) o;
            if (delay != null ? !delay.equals(that.delay) :that.delay != null) return false;
            if (errorMessage != null ? !errorMessage.equals(that.errorMessage) :that.errorMessage != null) return false;
            if (lastAttempt != null ? !lastAttempt.equals(that.lastAttempt) :that.lastAttempt != null) return false;
            if (response != null ? !response.equals(that.response) :that.response != null) return false;
            if (statusCode != null ? !statusCode.equals(that.statusCode) :that.statusCode != null) return false;
            if (version != null ? !version.equals(that.version) :that.version != null) return false;
            return true;
    }




}
