package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1DocumentManagementBindingSpecBuilder extends V1alpha1DocumentManagementBindingSpecFluentImpl<V1alpha1DocumentManagementBindingSpecBuilder> implements VisitableBuilder<V1alpha1DocumentManagementBindingSpec,V1alpha1DocumentManagementBindingSpecBuilder>{

    V1alpha1DocumentManagementBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1DocumentManagementBindingSpecBuilder(){
            this(true);
    }
    public V1alpha1DocumentManagementBindingSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1DocumentManagementBindingSpec(), validationEnabled);
    }
    public V1alpha1DocumentManagementBindingSpecBuilder(V1alpha1DocumentManagementBindingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1DocumentManagementBindingSpecBuilder(V1alpha1DocumentManagementBindingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1DocumentManagementBindingSpec(), validationEnabled);
    }
    public V1alpha1DocumentManagementBindingSpecBuilder(V1alpha1DocumentManagementBindingSpecFluent<?> fluent,V1alpha1DocumentManagementBindingSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1DocumentManagementBindingSpecBuilder(V1alpha1DocumentManagementBindingSpecFluent<?> fluent,V1alpha1DocumentManagementBindingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDocumentManagement(instance.getDocumentManagement());

            fluent.withDocumentManagementSpaceRefs(instance.getDocumentManagementSpaceRefs());

            fluent.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1DocumentManagementBindingSpecBuilder(V1alpha1DocumentManagementBindingSpec instance){
            this(instance,true);
    }
    public V1alpha1DocumentManagementBindingSpecBuilder(V1alpha1DocumentManagementBindingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDocumentManagement(instance.getDocumentManagement());

            this.withDocumentManagementSpaceRefs(instance.getDocumentManagementSpaceRefs());

            this.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1DocumentManagementBindingSpec build(){
            V1alpha1DocumentManagementBindingSpec buildable = new V1alpha1DocumentManagementBindingSpec();
            buildable.setDocumentManagement(fluent.getDocumentManagement());
            buildable.setDocumentManagementSpaceRefs(fluent.getDocumentManagementSpaceRefs());
            buildable.setSecret(fluent.getSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1DocumentManagementBindingSpecBuilder that = (V1alpha1DocumentManagementBindingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
