package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryPatternFluentImpl<A extends V1alpha1CodeRepositoryPatternFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CodeRepositoryPatternFluent<A>{

    private List<String> prefix;

    public V1alpha1CodeRepositoryPatternFluentImpl(){
    }
    public V1alpha1CodeRepositoryPatternFluentImpl(V1alpha1CodeRepositoryPattern instance){
            this.withPrefix(instance.getPrefix());

    }

    public A addToPrefix(int index,String item){
            if (this.prefix == null) {this.prefix = new ArrayList<String>();}
            this.prefix.add(index, item);
            return (A)this;
    }

    public A setToPrefix(int index,String item){
            if (this.prefix == null) {this.prefix = new ArrayList<String>();}
            this.prefix.set(index, item); return (A)this;
    }

    public A addToPrefix(String... items){
            if (this.prefix == null) {this.prefix = new ArrayList<String>();}
            for (String item : items) {this.prefix.add(item);} return (A)this;
    }

    public A addAllToPrefix(Collection<String> items){
            if (this.prefix == null) {this.prefix = new ArrayList<String>();}
            for (String item : items) {this.prefix.add(item);} return (A)this;
    }

    public A removeFromPrefix(String... items){
            for (String item : items) {if (this.prefix!= null){ this.prefix.remove(item);}} return (A)this;
    }

    public A removeAllFromPrefix(Collection<String> items){
            for (String item : items) {if (this.prefix!= null){ this.prefix.remove(item);}} return (A)this;
    }

    public List<String> getPrefix(){
            return this.prefix;
    }

    public String getPrefix(int index){
            return this.prefix.get(index);
    }

    public String getFirstPrefix(){
            return this.prefix.get(0);
    }

    public String getLastPrefix(){
            return this.prefix.get(prefix.size() - 1);
    }

    public String getMatchingPrefix(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: prefix) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingPrefix(io.alauda.devops.java.client.fluent.Predicate<String> predicate){
            for (String item: prefix) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withPrefix(List<String> prefix){
            if (this.prefix != null) { _visitables.get("prefix").removeAll(this.prefix);}
            if (prefix != null) {this.prefix = new ArrayList<String>(); for (String item : prefix){this.addToPrefix(item);}} else { this.prefix = null;} return (A) this;
    }

    public A withPrefix(String... prefix){
            if (this.prefix != null) {this.prefix.clear();}
            if (prefix != null) {for (String item :prefix){ this.addToPrefix(item);}} return (A) this;
    }

    public Boolean hasPrefix(){
            return prefix != null && !prefix.isEmpty();
    }

    public A addNewPrefix(String arg1){
            return (A)addToPrefix(new String(arg1));
    }

    public A addNewPrefix(StringBuilder arg1){
            return (A)addToPrefix(new String(arg1));
    }

    public A addNewPrefix(StringBuffer arg1){
            return (A)addToPrefix(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryPatternFluentImpl that = (V1alpha1CodeRepositoryPatternFluentImpl) o;
            if (prefix != null ? !prefix.equals(that.prefix) :that.prefix != null) return false;
            return true;
    }




}
