package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryPatternBuilder extends V1alpha1CodeRepositoryPatternFluentImpl<V1alpha1CodeRepositoryPatternBuilder> implements VisitableBuilder<V1alpha1CodeRepositoryPattern,V1alpha1CodeRepositoryPatternBuilder>{

    V1alpha1CodeRepositoryPatternFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepositoryPatternBuilder(){
            this(true);
    }
    public V1alpha1CodeRepositoryPatternBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepositoryPattern(), validationEnabled);
    }
    public V1alpha1CodeRepositoryPatternBuilder(V1alpha1CodeRepositoryPatternFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepositoryPatternBuilder(V1alpha1CodeRepositoryPatternFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepositoryPattern(), validationEnabled);
    }
    public V1alpha1CodeRepositoryPatternBuilder(V1alpha1CodeRepositoryPatternFluent<?> fluent,V1alpha1CodeRepositoryPattern instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepositoryPatternBuilder(V1alpha1CodeRepositoryPatternFluent<?> fluent,V1alpha1CodeRepositoryPattern instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPrefix(instance.getPrefix());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepositoryPatternBuilder(V1alpha1CodeRepositoryPattern instance){
            this(instance,true);
    }
    public V1alpha1CodeRepositoryPatternBuilder(V1alpha1CodeRepositoryPattern instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPrefix(instance.getPrefix());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepositoryPattern build(){
            V1alpha1CodeRepositoryPattern buildable = new V1alpha1CodeRepositoryPattern();
            buildable.setPrefix(fluent.getPrefix());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryPatternBuilder that = (V1alpha1CodeRepositoryPatternBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
