package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepositoryBuilder extends V1alpha1CodeRepositoryFluentImpl<V1alpha1CodeRepositoryBuilder> implements VisitableBuilder<V1alpha1CodeRepository,V1alpha1CodeRepositoryBuilder>{

    V1alpha1CodeRepositoryFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepositoryBuilder(){
            this(true);
    }
    public V1alpha1CodeRepositoryBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepository(), validationEnabled);
    }
    public V1alpha1CodeRepositoryBuilder(V1alpha1CodeRepositoryFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepositoryBuilder(V1alpha1CodeRepositoryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepository(), validationEnabled);
    }
    public V1alpha1CodeRepositoryBuilder(V1alpha1CodeRepositoryFluent<?> fluent,V1alpha1CodeRepository instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepositoryBuilder(V1alpha1CodeRepositoryFluent<?> fluent,V1alpha1CodeRepository instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepositoryBuilder(V1alpha1CodeRepository instance){
            this(instance,true);
    }
    public V1alpha1CodeRepositoryBuilder(V1alpha1CodeRepository instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepository build(){
            V1alpha1CodeRepository buildable = new V1alpha1CodeRepository();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepositoryBuilder that = (V1alpha1CodeRepositoryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
