package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoServiceSpecBuilder extends V1alpha1CodeRepoServiceSpecFluentImpl<V1alpha1CodeRepoServiceSpecBuilder> implements VisitableBuilder<V1alpha1CodeRepoServiceSpec,V1alpha1CodeRepoServiceSpecBuilder>{

    V1alpha1CodeRepoServiceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoServiceSpecBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoServiceSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoServiceSpec(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceSpecBuilder(V1alpha1CodeRepoServiceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoServiceSpecBuilder(V1alpha1CodeRepoServiceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoServiceSpec(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceSpecBuilder(V1alpha1CodeRepoServiceSpecFluent<?> fluent,V1alpha1CodeRepoServiceSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoServiceSpecBuilder(V1alpha1CodeRepoServiceSpecFluent<?> fluent,V1alpha1CodeRepoServiceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withData(instance.getData());

            fluent.withHttp(instance.getHttp());

            fluent.withPublic(instance.isPublic());

            fluent.withSecret(instance.getSecret());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoServiceSpecBuilder(V1alpha1CodeRepoServiceSpec instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoServiceSpecBuilder(V1alpha1CodeRepoServiceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withData(instance.getData());

            this.withHttp(instance.getHttp());

            this.withPublic(instance.isPublic());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoServiceSpec build(){
            V1alpha1CodeRepoServiceSpec buildable = new V1alpha1CodeRepoServiceSpec();
            buildable.setData(fluent.getData());
            buildable.setHttp(fluent.getHttp());
            buildable.setPublic(fluent.isPublic());
            buildable.setSecret(fluent.getSecret());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoServiceSpecBuilder that = (V1alpha1CodeRepoServiceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
