package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoServiceBuilder extends V1alpha1CodeRepoServiceFluentImpl<V1alpha1CodeRepoServiceBuilder> implements VisitableBuilder<V1alpha1CodeRepoService,V1alpha1CodeRepoServiceBuilder>{

    V1alpha1CodeRepoServiceFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoServiceBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoServiceBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoService(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceBuilder(V1alpha1CodeRepoServiceFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoServiceBuilder(V1alpha1CodeRepoServiceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoService(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceBuilder(V1alpha1CodeRepoServiceFluent<?> fluent,V1alpha1CodeRepoService instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoServiceBuilder(V1alpha1CodeRepoServiceFluent<?> fluent,V1alpha1CodeRepoService instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoServiceBuilder(V1alpha1CodeRepoService instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoServiceBuilder(V1alpha1CodeRepoService instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoService build(){
            V1alpha1CodeRepoService buildable = new V1alpha1CodeRepoService();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoServiceBuilder that = (V1alpha1CodeRepoServiceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
