package io.alauda.devops.java.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1alpha1CodeRepoServiceAuthorizeResponseFluentImpl<A extends V1alpha1CodeRepoServiceAuthorizeResponseFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CodeRepoServiceAuthorizeResponseFluent<A>{

    private String authorizeUrl;
    private Boolean gotAccessToken;
    private String redirectUrl;

    public V1alpha1CodeRepoServiceAuthorizeResponseFluentImpl(){
    }
    public V1alpha1CodeRepoServiceAuthorizeResponseFluentImpl(V1alpha1CodeRepoServiceAuthorizeResponse instance){
            this.withAuthorizeUrl(instance.getAuthorizeUrl());

            this.withGotAccessToken(instance.isGotAccessToken());

            this.withRedirectUrl(instance.getRedirectUrl());

    }

    public String getAuthorizeUrl(){
            return this.authorizeUrl;
    }

    public A withAuthorizeUrl(String authorizeUrl){
            this.authorizeUrl=authorizeUrl; return (A) this;
    }

    public Boolean hasAuthorizeUrl(){
            return this.authorizeUrl != null;
    }

    public A withNewAuthorizeUrl(String arg1){
            return (A)withAuthorizeUrl(new String(arg1));
    }

    public A withNewAuthorizeUrl(StringBuilder arg1){
            return (A)withAuthorizeUrl(new String(arg1));
    }

    public A withNewAuthorizeUrl(StringBuffer arg1){
            return (A)withAuthorizeUrl(new String(arg1));
    }

    public Boolean isGotAccessToken(){
            return this.gotAccessToken;
    }

    public A withGotAccessToken(Boolean gotAccessToken){
            this.gotAccessToken=gotAccessToken; return (A) this;
    }

    public Boolean hasGotAccessToken(){
            return this.gotAccessToken != null;
    }

    public A withNewGotAccessToken(String arg1){
            return (A)withGotAccessToken(new Boolean(arg1));
    }

    public A withNewGotAccessToken(boolean arg1){
            return (A)withGotAccessToken(new Boolean(arg1));
    }

    public String getRedirectUrl(){
            return this.redirectUrl;
    }

    public A withRedirectUrl(String redirectUrl){
            this.redirectUrl=redirectUrl; return (A) this;
    }

    public Boolean hasRedirectUrl(){
            return this.redirectUrl != null;
    }

    public A withNewRedirectUrl(String arg1){
            return (A)withRedirectUrl(new String(arg1));
    }

    public A withNewRedirectUrl(StringBuilder arg1){
            return (A)withRedirectUrl(new String(arg1));
    }

    public A withNewRedirectUrl(StringBuffer arg1){
            return (A)withRedirectUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoServiceAuthorizeResponseFluentImpl that = (V1alpha1CodeRepoServiceAuthorizeResponseFluentImpl) o;
            if (authorizeUrl != null ? !authorizeUrl.equals(that.authorizeUrl) :that.authorizeUrl != null) return false;
            if (gotAccessToken != null ? !gotAccessToken.equals(that.gotAccessToken) :that.gotAccessToken != null) return false;
            if (redirectUrl != null ? !redirectUrl.equals(that.redirectUrl) :that.redirectUrl != null) return false;
            return true;
    }




}
