package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoServiceAuthorizeResponseBuilder extends V1alpha1CodeRepoServiceAuthorizeResponseFluentImpl<V1alpha1CodeRepoServiceAuthorizeResponseBuilder> implements VisitableBuilder<V1alpha1CodeRepoServiceAuthorizeResponse,V1alpha1CodeRepoServiceAuthorizeResponseBuilder>{

    V1alpha1CodeRepoServiceAuthorizeResponseFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoServiceAuthorizeResponseBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoServiceAuthorizeResponseBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoServiceAuthorizeResponse(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceAuthorizeResponseBuilder(V1alpha1CodeRepoServiceAuthorizeResponseFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoServiceAuthorizeResponseBuilder(V1alpha1CodeRepoServiceAuthorizeResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoServiceAuthorizeResponse(), validationEnabled);
    }
    public V1alpha1CodeRepoServiceAuthorizeResponseBuilder(V1alpha1CodeRepoServiceAuthorizeResponseFluent<?> fluent,V1alpha1CodeRepoServiceAuthorizeResponse instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoServiceAuthorizeResponseBuilder(V1alpha1CodeRepoServiceAuthorizeResponseFluent<?> fluent,V1alpha1CodeRepoServiceAuthorizeResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuthorizeUrl(instance.getAuthorizeUrl());

            fluent.withGotAccessToken(instance.isGotAccessToken());

            fluent.withRedirectUrl(instance.getRedirectUrl());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoServiceAuthorizeResponseBuilder(V1alpha1CodeRepoServiceAuthorizeResponse instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoServiceAuthorizeResponseBuilder(V1alpha1CodeRepoServiceAuthorizeResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuthorizeUrl(instance.getAuthorizeUrl());

            this.withGotAccessToken(instance.isGotAccessToken());

            this.withRedirectUrl(instance.getRedirectUrl());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoServiceAuthorizeResponse build(){
            V1alpha1CodeRepoServiceAuthorizeResponse buildable = new V1alpha1CodeRepoServiceAuthorizeResponse();
            buildable.setAuthorizeUrl(fluent.getAuthorizeUrl());
            buildable.setGotAccessToken(fluent.isGotAccessToken());
            buildable.setRedirectUrl(fluent.getRedirectUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoServiceAuthorizeResponseBuilder that = (V1alpha1CodeRepoServiceAuthorizeResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
