package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeRepoBranchOptionsBuilder extends V1alpha1CodeRepoBranchOptionsFluentImpl<V1alpha1CodeRepoBranchOptionsBuilder> implements VisitableBuilder<V1alpha1CodeRepoBranchOptions,V1alpha1CodeRepoBranchOptionsBuilder>{

    V1alpha1CodeRepoBranchOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeRepoBranchOptionsBuilder(){
            this(true);
    }
    public V1alpha1CodeRepoBranchOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeRepoBranchOptions(), validationEnabled);
    }
    public V1alpha1CodeRepoBranchOptionsBuilder(V1alpha1CodeRepoBranchOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeRepoBranchOptionsBuilder(V1alpha1CodeRepoBranchOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeRepoBranchOptions(), validationEnabled);
    }
    public V1alpha1CodeRepoBranchOptionsBuilder(V1alpha1CodeRepoBranchOptionsFluent<?> fluent,V1alpha1CodeRepoBranchOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeRepoBranchOptionsBuilder(V1alpha1CodeRepoBranchOptionsFluent<?> fluent,V1alpha1CodeRepoBranchOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withSortBy(instance.getSortBy());

            fluent.withSortMode(instance.getSortMode());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeRepoBranchOptionsBuilder(V1alpha1CodeRepoBranchOptions instance){
            this(instance,true);
    }
    public V1alpha1CodeRepoBranchOptionsBuilder(V1alpha1CodeRepoBranchOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withSortBy(instance.getSortBy());

            this.withSortMode(instance.getSortMode());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeRepoBranchOptions build(){
            V1alpha1CodeRepoBranchOptions buildable = new V1alpha1CodeRepoBranchOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setSortBy(fluent.getSortBy());
            buildable.setSortMode(fluent.getSortMode());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoBranchOptionsBuilder that = (V1alpha1CodeRepoBranchOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
