package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1CodeRepoBindingReplicaTemplateFluentImpl<A extends V1alpha1CodeRepoBindingReplicaTemplateFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CodeRepoBindingReplicaTemplateFluent<A>{

    private List<V1alpha1OwnerInRepositoryBuilder> owners;
    private V1alpha1CodeRepoBindingReplicaTemplateSpecBuilder template;

    public V1alpha1CodeRepoBindingReplicaTemplateFluentImpl(){
    }
    public V1alpha1CodeRepoBindingReplicaTemplateFluentImpl(V1alpha1CodeRepoBindingReplicaTemplate instance){
            this.withOwners(instance.getOwners());

            this.withTemplate(instance.getTemplate());

    }

    public A addToOwners(int index,V1alpha1OwnerInRepository item){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1OwnerInRepositoryBuilder>();}
            V1alpha1OwnerInRepositoryBuilder builder = new V1alpha1OwnerInRepositoryBuilder(item);_visitables.get("owners").add(index >= 0 ? index : _visitables.get("owners").size(), builder);this.owners.add(index >= 0 ? index : owners.size(), builder); return (A)this;
    }

    public A setToOwners(int index,V1alpha1OwnerInRepository item){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1OwnerInRepositoryBuilder>();}
            V1alpha1OwnerInRepositoryBuilder builder = new V1alpha1OwnerInRepositoryBuilder(item);
            if (index < 0 || index >= _visitables.get("owners").size()) { _visitables.get("owners").add(builder); } else { _visitables.get("owners").set(index, builder);}
            if (index < 0 || index >= owners.size()) { owners.add(builder); } else { owners.set(index, builder);}
             return (A)this;
    }

    public A addToOwners(V1alpha1OwnerInRepository... items){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1OwnerInRepositoryBuilder>();}
            for (V1alpha1OwnerInRepository item : items) {V1alpha1OwnerInRepositoryBuilder builder = new V1alpha1OwnerInRepositoryBuilder(item);_visitables.get("owners").add(builder);this.owners.add(builder);} return (A)this;
    }

    public A addAllToOwners(Collection<V1alpha1OwnerInRepository> items){
            if (this.owners == null) {this.owners = new ArrayList<V1alpha1OwnerInRepositoryBuilder>();}
            for (V1alpha1OwnerInRepository item : items) {V1alpha1OwnerInRepositoryBuilder builder = new V1alpha1OwnerInRepositoryBuilder(item);_visitables.get("owners").add(builder);this.owners.add(builder);} return (A)this;
    }

    public A removeFromOwners(V1alpha1OwnerInRepository... items){
            for (V1alpha1OwnerInRepository item : items) {V1alpha1OwnerInRepositoryBuilder builder = new V1alpha1OwnerInRepositoryBuilder(item);_visitables.get("owners").remove(builder);if (this.owners != null) {this.owners.remove(builder);}} return (A)this;
    }

    public A removeAllFromOwners(Collection<V1alpha1OwnerInRepository> items){
            for (V1alpha1OwnerInRepository item : items) {V1alpha1OwnerInRepositoryBuilder builder = new V1alpha1OwnerInRepositoryBuilder(item);_visitables.get("owners").remove(builder);if (this.owners != null) {this.owners.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOwners instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1OwnerInRepository> getOwners(){
            return build(owners);
    }

    public List<V1alpha1OwnerInRepository> buildOwners(){
            return build(owners);
    }

    public V1alpha1OwnerInRepository buildOwner(int index){
            return this.owners.get(index).build();
    }

    public V1alpha1OwnerInRepository buildFirstOwner(){
            return this.owners.get(0).build();
    }

    public V1alpha1OwnerInRepository buildLastOwner(){
            return this.owners.get(owners.size() - 1).build();
    }

    public V1alpha1OwnerInRepository buildMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1OwnerInRepositoryBuilder> predicate){
            for (V1alpha1OwnerInRepositoryBuilder item: owners) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1OwnerInRepositoryBuilder> predicate){
            for (V1alpha1OwnerInRepositoryBuilder item: owners) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withOwners(List<V1alpha1OwnerInRepository> owners){
            if (this.owners != null) { _visitables.get("owners").removeAll(this.owners);}
            if (owners != null) {this.owners = new ArrayList<V1alpha1OwnerInRepositoryBuilder>(); for (V1alpha1OwnerInRepository item : owners){this.addToOwners(item);}} else { this.owners = null;} return (A) this;
    }

    public A withOwners(V1alpha1OwnerInRepository... owners){
            if (this.owners != null) {this.owners.clear();}
            if (owners != null) {for (V1alpha1OwnerInRepository item :owners){ this.addToOwners(item);}} return (A) this;
    }

    public Boolean hasOwners(){
            return owners != null && !owners.isEmpty();
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<A> addNewOwner(){
            return new OwnersNestedImpl();
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<A> addNewOwnerLike(V1alpha1OwnerInRepository item){
            return new OwnersNestedImpl(-1, item);
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<A> setNewOwnerLike(int index,V1alpha1OwnerInRepository item){
            return new OwnersNestedImpl(index, item);
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<A> editOwner(int index){
            if (owners.size() <= index) throw new RuntimeException("Can't edit owners. Index exceeds size.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<A> editFirstOwner(){
            if (owners.size() == 0) throw new RuntimeException("Can't edit first owners. The list is empty.");
            return setNewOwnerLike(0, buildOwner(0));
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<A> editLastOwner(){
            int index = owners.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last owners. The list is empty.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<A> editMatchingOwner(io.alauda.devops.java.client.fluent.Predicate<V1alpha1OwnerInRepositoryBuilder> predicate){
            int index = -1;
            for (int i=0;i<owners.size();i++) { 
            if (predicate.apply(owners.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching owners. No match found.");
            return setNewOwnerLike(index, buildOwner(index));
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1CodeRepoBindingReplicaTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1alpha1CodeRepoBindingReplicaTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1alpha1CodeRepoBindingReplicaTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1alpha1CodeRepoBindingReplicaTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.TemplateNested<A> withNewTemplateLike(V1alpha1CodeRepoBindingReplicaTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1alpha1CodeRepoBindingReplicaTemplateSpecBuilder().build());
    }

    public V1alpha1CodeRepoBindingReplicaTemplateFluent.TemplateNested<A> editOrNewTemplateLike(V1alpha1CodeRepoBindingReplicaTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeRepoBindingReplicaTemplateFluentImpl that = (V1alpha1CodeRepoBindingReplicaTemplateFluentImpl) o;
            if (owners != null ? !owners.equals(that.owners) :that.owners != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class OwnersNestedImpl<N> extends V1alpha1OwnerInRepositoryFluentImpl<V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<N>> implements V1alpha1CodeRepoBindingReplicaTemplateFluent.OwnersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1OwnerInRepositoryBuilder builder;
        private final int index;
    
            OwnersNestedImpl(int index,V1alpha1OwnerInRepository item){
                    this.index = index;
                    this.builder = new V1alpha1OwnerInRepositoryBuilder(this, item);
            }
            OwnersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1OwnerInRepositoryBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1CodeRepoBindingReplicaTemplateFluentImpl.this.setToOwners(index, builder.build());
    }
    public N endOwner(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1alpha1CodeRepoBindingReplicaTemplateSpecFluentImpl<V1alpha1CodeRepoBindingReplicaTemplateFluent.TemplateNested<N>> implements V1alpha1CodeRepoBindingReplicaTemplateFluent.TemplateNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1CodeRepoBindingReplicaTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1alpha1CodeRepoBindingReplicaTemplateSpec item){
                    this.builder = new V1alpha1CodeRepoBindingReplicaTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1alpha1CodeRepoBindingReplicaTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1CodeRepoBindingReplicaTemplateFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
