package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CodeQualityProjectSpecBuilder extends V1alpha1CodeQualityProjectSpecFluentImpl<V1alpha1CodeQualityProjectSpecBuilder> implements VisitableBuilder<V1alpha1CodeQualityProjectSpec,V1alpha1CodeQualityProjectSpecBuilder>{

    V1alpha1CodeQualityProjectSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CodeQualityProjectSpecBuilder(){
            this(true);
    }
    public V1alpha1CodeQualityProjectSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1CodeQualityProjectSpec(), validationEnabled);
    }
    public V1alpha1CodeQualityProjectSpecBuilder(V1alpha1CodeQualityProjectSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CodeQualityProjectSpecBuilder(V1alpha1CodeQualityProjectSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CodeQualityProjectSpec(), validationEnabled);
    }
    public V1alpha1CodeQualityProjectSpecBuilder(V1alpha1CodeQualityProjectSpecFluent<?> fluent,V1alpha1CodeQualityProjectSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1CodeQualityProjectSpecBuilder(V1alpha1CodeQualityProjectSpecFluent<?> fluent,V1alpha1CodeQualityProjectSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCodeQualityBinding(instance.getCodeQualityBinding());

            fluent.withCodeQualityTool(instance.getCodeQualityTool());

            fluent.withCodeRepository(instance.getCodeRepository());

            fluent.withProject(instance.getProject());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CodeQualityProjectSpecBuilder(V1alpha1CodeQualityProjectSpec instance){
            this(instance,true);
    }
    public V1alpha1CodeQualityProjectSpecBuilder(V1alpha1CodeQualityProjectSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCodeQualityBinding(instance.getCodeQualityBinding());

            this.withCodeQualityTool(instance.getCodeQualityTool());

            this.withCodeRepository(instance.getCodeRepository());

            this.withProject(instance.getProject());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CodeQualityProjectSpec build(){
            V1alpha1CodeQualityProjectSpec buildable = new V1alpha1CodeQualityProjectSpec();
            buildable.setCodeQualityBinding(fluent.getCodeQualityBinding());
            buildable.setCodeQualityTool(fluent.getCodeQualityTool());
            buildable.setCodeRepository(fluent.getCodeRepository());
            buildable.setProject(fluent.getProject());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityProjectSpecBuilder that = (V1alpha1CodeQualityProjectSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
