package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1CIBindingReplicaTemplateBuilder extends V1alpha1CIBindingReplicaTemplateFluentImpl<V1alpha1CIBindingReplicaTemplateBuilder> implements VisitableBuilder<V1alpha1CIBindingReplicaTemplate,V1alpha1CIBindingReplicaTemplateBuilder>{

    V1alpha1CIBindingReplicaTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1CIBindingReplicaTemplateBuilder(){
            this(true);
    }
    public V1alpha1CIBindingReplicaTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1CIBindingReplicaTemplate(), validationEnabled);
    }
    public V1alpha1CIBindingReplicaTemplateBuilder(V1alpha1CIBindingReplicaTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1CIBindingReplicaTemplateBuilder(V1alpha1CIBindingReplicaTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1CIBindingReplicaTemplate(), validationEnabled);
    }
    public V1alpha1CIBindingReplicaTemplateBuilder(V1alpha1CIBindingReplicaTemplateFluent<?> fluent,V1alpha1CIBindingReplicaTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1CIBindingReplicaTemplateBuilder(V1alpha1CIBindingReplicaTemplateFluent<?> fluent,V1alpha1CIBindingReplicaTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1CIBindingReplicaTemplateBuilder(V1alpha1CIBindingReplicaTemplate instance){
            this(instance,true);
    }
    public V1alpha1CIBindingReplicaTemplateBuilder(V1alpha1CIBindingReplicaTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1CIBindingReplicaTemplate build(){
            V1alpha1CIBindingReplicaTemplate buildable = new V1alpha1CIBindingReplicaTemplate();
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CIBindingReplicaTemplateBuilder that = (V1alpha1CIBindingReplicaTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
