/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue.ratelimiter;

import io.alauda.devops.java.client.extend.workqueue.ratelimiter.RateLimiter;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.Refill;
import io.github.bucket4j.local.LocalBucketBuilder;
import io.github.bucket4j.local.SynchronizationStrategy;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BucketRateLimiter<T>
implements RateLimiter<T> {
    private Bucket bucket;

    public BucketRateLimiter(long capacity, long tokensGeneratedInPeriod, Duration period) {
        Bandwidth bandwidth = Bandwidth.classic((long)capacity, (Refill)Refill.greedy((long)tokensGeneratedInPeriod, (Duration)period));
        this.bucket = ((LocalBucketBuilder)Bucket4j.builder().addLimit(bandwidth)).withSynchronizationStrategy(SynchronizationStrategy.SYNCHRONIZED).build();
    }

    @Override
    public Duration when(T item) {
        DelayGetter delayGetter = new DelayGetter();
        this.bucket.asAsyncScheduler().consume(1L, (ScheduledExecutorService)delayGetter).complete(null);
        return delayGetter.getDelay();
    }

    @Override
    public void forget(T item) {
    }

    @Override
    public int numRequeues(T item) {
        return 0;
    }

    private class DelayGetter
    extends ScheduledThreadPoolExecutor {
        private Duration delay;

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            this.delay = Duration.ofNanos(unit.toNanos(delay));
            return null;
        }

        private DelayGetter() {
            super(0);
            this.delay = Duration.ZERO;
        }

        private Duration getDelay() {
            return this.delay;
        }
    }
}

