/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue;

import io.alauda.devops.java.client.extend.workqueue.DefaultDelayingQueue;
import io.alauda.devops.java.client.extend.workqueue.RateLimitingQueue;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.DefaultControllerRateLimiter;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.RateLimiter;
import java.util.concurrent.ExecutorService;

public class DefaultRateLimitingQueue<T>
extends DefaultDelayingQueue<T>
implements RateLimitingQueue<T> {
    private RateLimiter<T> rateLimiter;

    public DefaultRateLimitingQueue(ExecutorService waitingWorker) {
        super(waitingWorker);
        this.rateLimiter = new DefaultControllerRateLimiter();
    }

    public DefaultRateLimitingQueue(ExecutorService waitingWorker, RateLimiter<T> rateLimiter) {
        super(waitingWorker);
        this.rateLimiter = rateLimiter;
    }

    @Override
    public int numRequeues(T item) {
        return this.rateLimiter.numRequeues(item);
    }

    @Override
    public void forget(T item) {
        this.rateLimiter.forget(item);
    }

    @Override
    public void addRateLimited(T item) {
        super.addAfter(item, this.rateLimiter.when(item));
    }
}

