/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.controller;

import io.alauda.devops.java.client.extend.controller.ControllerWatch;
import io.alauda.devops.java.client.extend.controller.reconciler.Request;
import io.alauda.devops.java.client.extend.workqueue.WorkQueue;
import io.kubernetes.client.informer.ResourceEventHandler;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class DefaultControllerWatch<ApiType>
implements ControllerWatch<ApiType> {
    private final WorkQueue<Request> workQueue;
    private final Function<ApiType, Request> workKeyGenerator;
    private Class<ApiType> apiTypeClass;
    private Predicate<ApiType> onAddFilterPredicate;
    private BiPredicate<ApiType, ApiType> onUpdateFilterPredicate;
    private BiPredicate<ApiType, Boolean> onDeleteFilterPredicate;

    public DefaultControllerWatch(Class<ApiType> apiTypeClass, WorkQueue<Request> workQueue, Function<ApiType, Request> workKeyGenerator) {
        this.workQueue = workQueue;
        this.apiTypeClass = apiTypeClass;
        this.workKeyGenerator = workKeyGenerator;
    }

    public Predicate<ApiType> getOnAddFilterPredicate() {
        return this.onAddFilterPredicate;
    }

    public void setOnAddFilterPredicate(Predicate<ApiType> onAddFilterPredicate) {
        this.onAddFilterPredicate = onAddFilterPredicate;
    }

    public BiPredicate<ApiType, ApiType> getOnUpdateFilterPredicate() {
        return this.onUpdateFilterPredicate;
    }

    public void setOnUpdateFilterPredicate(BiPredicate<ApiType, ApiType> onUpdateFilterPredicate) {
        this.onUpdateFilterPredicate = onUpdateFilterPredicate;
    }

    public BiPredicate<ApiType, Boolean> getOnDeleteFilterPredicate() {
        return this.onDeleteFilterPredicate;
    }

    public void setOnDeleteFilterPredicate(BiPredicate<ApiType, Boolean> onDeleteFilterPredicate) {
        this.onDeleteFilterPredicate = onDeleteFilterPredicate;
    }

    public Class<ApiType> getApiTypeClass() {
        return this.apiTypeClass;
    }

    public void setApiTypeClass(Class<ApiType> apiTypeClass) {
        this.apiTypeClass = apiTypeClass;
    }

    @Override
    public Class<ApiType> getResourceClass() {
        return this.apiTypeClass;
    }

    @Override
    public ResourceEventHandler<ApiType> getResourceEventHandler() {
        return new ResourceEventHandler<ApiType>(){

            public void onAdd(ApiType obj) {
                if (DefaultControllerWatch.this.onAddFilterPredicate == null || DefaultControllerWatch.this.onAddFilterPredicate.test(obj)) {
                    DefaultControllerWatch.this.workQueue.add(DefaultControllerWatch.this.workKeyGenerator.apply(obj));
                }
            }

            public void onUpdate(ApiType oldObj, ApiType newObj) {
                if (DefaultControllerWatch.this.onUpdateFilterPredicate == null || DefaultControllerWatch.this.onUpdateFilterPredicate.test(oldObj, newObj)) {
                    DefaultControllerWatch.this.workQueue.add(DefaultControllerWatch.this.workKeyGenerator.apply(newObj));
                }
            }

            public void onDelete(ApiType obj, boolean deletedFinalStateUnknown) {
                if (DefaultControllerWatch.this.onDeleteFilterPredicate == null || DefaultControllerWatch.this.onDeleteFilterPredicate.test(obj, deletedFinalStateUnknown)) {
                    DefaultControllerWatch.this.workQueue.add(DefaultControllerWatch.this.workKeyGenerator.apply(obj));
                }
            }
        };
    }
}

