/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.devops.java.client.extend.workqueue;

import io.alauda.devops.java.client.extend.workqueue.DefaultRateLimitingQueue;
import io.alauda.devops.java.client.extend.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DefaultRateLimitQueueTest {
    @Test
    public void testSimpleRateLimitQueue() throws Exception {
        MockRateLimiter mockRateLimiter = new MockRateLimiter();
        DefaultRateLimitingQueue rlq = new DefaultRateLimitingQueue(Executors.newSingleThreadExecutor(), mockRateLimiter);
        long t1 = System.nanoTime();
        rlq.addRateLimited((Object)"foo");
        rlq.get();
        long t2 = System.nanoTime();
        Assert.assertTrue((t2 - t1 > TimeUnit.MILLISECONDS.toNanos(500L) ? 1 : 0) != 0);
    }

    private static class MockRateLimiter<T>
    implements RateLimiter<T> {
        private int count;

        private MockRateLimiter() {
        }

        public Duration when(Object item) {
            return Duration.ofMillis(500L);
        }

        public void forget(Object item) {
            this.count = 0;
        }

        public int numRequeues(Object item) {
            int requeue = this.count++;
            return requeue;
        }
    }
}

