package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1UserSearchOptionsBuilder extends V1alpha1UserSearchOptionsFluentImpl<V1alpha1UserSearchOptionsBuilder> implements VisitableBuilder<V1alpha1UserSearchOptions,V1alpha1UserSearchOptionsBuilder>{

    V1alpha1UserSearchOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1UserSearchOptionsBuilder(){
            this(true);
    }
    public V1alpha1UserSearchOptionsBuilder(Boolean validationEnabled){
            this(new V1alpha1UserSearchOptions(), validationEnabled);
    }
    public V1alpha1UserSearchOptionsBuilder(V1alpha1UserSearchOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1UserSearchOptionsBuilder(V1alpha1UserSearchOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1UserSearchOptions(), validationEnabled);
    }
    public V1alpha1UserSearchOptionsBuilder(V1alpha1UserSearchOptionsFluent<?> fluent,V1alpha1UserSearchOptions instance){
            this(fluent, instance, true);
    }
    public V1alpha1UserSearchOptionsBuilder(V1alpha1UserSearchOptionsFluent<?> fluent,V1alpha1UserSearchOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            fluent.withSecretname(instance.getSecretname());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1UserSearchOptionsBuilder(V1alpha1UserSearchOptions instance){
            this(instance,true);
    }
    public V1alpha1UserSearchOptionsBuilder(V1alpha1UserSearchOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withSecretname(instance.getSecretname());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1UserSearchOptions build(){
            V1alpha1UserSearchOptions buildable = new V1alpha1UserSearchOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            buildable.setSecretname(fluent.getSecretname());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1UserSearchOptionsBuilder that = (V1alpha1UserSearchOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
