package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ToolBindingReplicaSpecBuilder extends V1alpha1ToolBindingReplicaSpecFluentImpl<V1alpha1ToolBindingReplicaSpecBuilder> implements VisitableBuilder<V1alpha1ToolBindingReplicaSpec,V1alpha1ToolBindingReplicaSpecBuilder>{

    V1alpha1ToolBindingReplicaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ToolBindingReplicaSpecBuilder(){
            this(true);
    }
    public V1alpha1ToolBindingReplicaSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ToolBindingReplicaSpec(), validationEnabled);
    }
    public V1alpha1ToolBindingReplicaSpecBuilder(V1alpha1ToolBindingReplicaSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ToolBindingReplicaSpecBuilder(V1alpha1ToolBindingReplicaSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ToolBindingReplicaSpec(), validationEnabled);
    }
    public V1alpha1ToolBindingReplicaSpecBuilder(V1alpha1ToolBindingReplicaSpecFluent<?> fluent,V1alpha1ToolBindingReplicaSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ToolBindingReplicaSpecBuilder(V1alpha1ToolBindingReplicaSpecFluent<?> fluent,V1alpha1ToolBindingReplicaSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withArtifactRegistry(instance.getArtifactRegistry());

            fluent.withCodeQualityTool(instance.getCodeQualityTool());

            fluent.withCodeRepoService(instance.getCodeRepoService());

            fluent.withContinuousIntegration(instance.getContinuousIntegration());

            fluent.withDocumentManagement(instance.getDocumentManagement());

            fluent.withImageRegistry(instance.getImageRegistry());

            fluent.withProjectManagement(instance.getProjectManagement());

            fluent.withSecret(instance.getSecret());

            fluent.withSelector(instance.getSelector());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ToolBindingReplicaSpecBuilder(V1alpha1ToolBindingReplicaSpec instance){
            this(instance,true);
    }
    public V1alpha1ToolBindingReplicaSpecBuilder(V1alpha1ToolBindingReplicaSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withArtifactRegistry(instance.getArtifactRegistry());

            this.withCodeQualityTool(instance.getCodeQualityTool());

            this.withCodeRepoService(instance.getCodeRepoService());

            this.withContinuousIntegration(instance.getContinuousIntegration());

            this.withDocumentManagement(instance.getDocumentManagement());

            this.withImageRegistry(instance.getImageRegistry());

            this.withProjectManagement(instance.getProjectManagement());

            this.withSecret(instance.getSecret());

            this.withSelector(instance.getSelector());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ToolBindingReplicaSpec build(){
            V1alpha1ToolBindingReplicaSpec buildable = new V1alpha1ToolBindingReplicaSpec();
            buildable.setArtifactRegistry(fluent.getArtifactRegistry());
            buildable.setCodeQualityTool(fluent.getCodeQualityTool());
            buildable.setCodeRepoService(fluent.getCodeRepoService());
            buildable.setContinuousIntegration(fluent.getContinuousIntegration());
            buildable.setDocumentManagement(fluent.getDocumentManagement());
            buildable.setImageRegistry(fluent.getImageRegistry());
            buildable.setProjectManagement(fluent.getProjectManagement());
            buildable.setSecret(fluent.getSecret());
            buildable.setSelector(fluent.getSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ToolBindingReplicaSpecBuilder that = (V1alpha1ToolBindingReplicaSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
