package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1TaskConstValueBuilder extends V1alpha1TaskConstValueFluentImpl<V1alpha1TaskConstValueBuilder> implements VisitableBuilder<V1alpha1TaskConstValue,V1alpha1TaskConstValueBuilder>{

    V1alpha1TaskConstValueFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1TaskConstValueBuilder(){
            this(true);
    }
    public V1alpha1TaskConstValueBuilder(Boolean validationEnabled){
            this(new V1alpha1TaskConstValue(), validationEnabled);
    }
    public V1alpha1TaskConstValueBuilder(V1alpha1TaskConstValueFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1TaskConstValueBuilder(V1alpha1TaskConstValueFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1TaskConstValue(), validationEnabled);
    }
    public V1alpha1TaskConstValueBuilder(V1alpha1TaskConstValueFluent<?> fluent,V1alpha1TaskConstValue instance){
            this(fluent, instance, true);
    }
    public V1alpha1TaskConstValueBuilder(V1alpha1TaskConstValueFluent<?> fluent,V1alpha1TaskConstValue instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApprove(instance.getApprove());

            fluent.withArgs(instance.getArgs());

            fluent.withOptions(instance.getOptions());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1TaskConstValueBuilder(V1alpha1TaskConstValue instance){
            this(instance,true);
    }
    public V1alpha1TaskConstValueBuilder(V1alpha1TaskConstValue instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApprove(instance.getApprove());

            this.withArgs(instance.getArgs());

            this.withOptions(instance.getOptions());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1TaskConstValue build(){
            V1alpha1TaskConstValue buildable = new V1alpha1TaskConstValue();
            buildable.setApprove(fluent.getApprove());
            buildable.setArgs(fluent.getArgs());
            buildable.setOptions(fluent.getOptions());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1TaskConstValueBuilder that = (V1alpha1TaskConstValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
