package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1SummaryBuilder extends V1alpha1SummaryFluentImpl<V1alpha1SummaryBuilder> implements VisitableBuilder<V1alpha1Summary,V1alpha1SummaryBuilder>{

    V1alpha1SummaryFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1SummaryBuilder(){
            this(true);
    }
    public V1alpha1SummaryBuilder(Boolean validationEnabled){
            this(new V1alpha1Summary(), validationEnabled);
    }
    public V1alpha1SummaryBuilder(V1alpha1SummaryFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1SummaryBuilder(V1alpha1SummaryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1Summary(), validationEnabled);
    }
    public V1alpha1SummaryBuilder(V1alpha1SummaryFluent<?> fluent,V1alpha1Summary instance){
            this(fluent, instance, true);
    }
    public V1alpha1SummaryBuilder(V1alpha1SummaryFluent<?> fluent,V1alpha1Summary instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCount(instance.getCount());

            fluent.withSeverity(instance.getSeverity());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1SummaryBuilder(V1alpha1Summary instance){
            this(instance,true);
    }
    public V1alpha1SummaryBuilder(V1alpha1Summary instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCount(instance.getCount());

            this.withSeverity(instance.getSeverity());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1Summary build(){
            V1alpha1Summary buildable = new V1alpha1Summary();
            buildable.setCount(fluent.getCount());
            buildable.setSeverity(fluent.getSeverity());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1SummaryBuilder that = (V1alpha1SummaryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
