package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskTemplateSpecBuilder extends V1alpha1PipelineTaskTemplateSpecFluentImpl<V1alpha1PipelineTaskTemplateSpecBuilder> implements VisitableBuilder<V1alpha1PipelineTaskTemplateSpec,V1alpha1PipelineTaskTemplateSpecBuilder>{

    V1alpha1PipelineTaskTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskTemplateSpecBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskTemplateSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTaskTemplateSpec(), validationEnabled);
    }
    public V1alpha1PipelineTaskTemplateSpecBuilder(V1alpha1PipelineTaskTemplateSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskTemplateSpecBuilder(V1alpha1PipelineTaskTemplateSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTaskTemplateSpec(), validationEnabled);
    }
    public V1alpha1PipelineTaskTemplateSpecBuilder(V1alpha1PipelineTaskTemplateSpecFluent<?> fluent,V1alpha1PipelineTaskTemplateSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskTemplateSpecBuilder(V1alpha1PipelineTaskTemplateSpecFluent<?> fluent,V1alpha1PipelineTaskTemplateSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAgent(instance.getAgent());

            fluent.withArguments(instance.getArguments());

            fluent.withBody(instance.getBody());

            fluent.withDependencies(instance.getDependencies());

            fluent.withEngine(instance.getEngine());

            fluent.withExports(instance.getExports());

            fluent.withParameters(instance.getParameters());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskTemplateSpecBuilder(V1alpha1PipelineTaskTemplateSpec instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskTemplateSpecBuilder(V1alpha1PipelineTaskTemplateSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAgent(instance.getAgent());

            this.withArguments(instance.getArguments());

            this.withBody(instance.getBody());

            this.withDependencies(instance.getDependencies());

            this.withEngine(instance.getEngine());

            this.withExports(instance.getExports());

            this.withParameters(instance.getParameters());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTaskTemplateSpec build(){
            V1alpha1PipelineTaskTemplateSpec buildable = new V1alpha1PipelineTaskTemplateSpec();
            buildable.setAgent(fluent.getAgent());
            buildable.setArguments(fluent.getArguments());
            buildable.setBody(fluent.getBody());
            buildable.setDependencies(fluent.getDependencies());
            buildable.setEngine(fluent.getEngine());
            buildable.setExports(fluent.getExports());
            buildable.setParameters(fluent.getParameters());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskTemplateSpecBuilder that = (V1alpha1PipelineTaskTemplateSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
