package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTaskArgumentActionBuilder extends V1alpha1PipelineTaskArgumentActionFluentImpl<V1alpha1PipelineTaskArgumentActionBuilder> implements VisitableBuilder<V1alpha1PipelineTaskArgumentAction,V1alpha1PipelineTaskArgumentActionBuilder>{

    V1alpha1PipelineTaskArgumentActionFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTaskArgumentActionBuilder(){
            this(true);
    }
    public V1alpha1PipelineTaskArgumentActionBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTaskArgumentAction(), validationEnabled);
    }
    public V1alpha1PipelineTaskArgumentActionBuilder(V1alpha1PipelineTaskArgumentActionFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTaskArgumentActionBuilder(V1alpha1PipelineTaskArgumentActionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTaskArgumentAction(), validationEnabled);
    }
    public V1alpha1PipelineTaskArgumentActionBuilder(V1alpha1PipelineTaskArgumentActionFluent<?> fluent,V1alpha1PipelineTaskArgumentAction instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTaskArgumentActionBuilder(V1alpha1PipelineTaskArgumentActionFluent<?> fluent,V1alpha1PipelineTaskArgumentAction instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAction(instance.getAction());

            fluent.withWhen(instance.getWhen());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTaskArgumentActionBuilder(V1alpha1PipelineTaskArgumentAction instance){
            this(instance,true);
    }
    public V1alpha1PipelineTaskArgumentActionBuilder(V1alpha1PipelineTaskArgumentAction instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAction(instance.getAction());

            this.withWhen(instance.getWhen());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTaskArgumentAction build(){
            V1alpha1PipelineTaskArgumentAction buildable = new V1alpha1PipelineTaskArgumentAction();
            buildable.setAction(fluent.getAction());
            buildable.setWhen(fluent.getWhen());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTaskArgumentActionBuilder that = (V1alpha1PipelineTaskArgumentActionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
