package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import io.kubernetes.client.models.V1ObjectMeta;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineFluentImpl<A extends V1alpha1PipelineFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMeta metadata;
    private V1alpha1PipelineSpecBuilder spec;
    private V1alpha1PipelineStatusBuilder status;

    public V1alpha1PipelineFluentImpl(){
    }
    public V1alpha1PipelineFluentImpl(V1alpha1Pipeline instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public V1ObjectMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(V1ObjectMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V1alpha1PipelineSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1alpha1PipelineSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new V1alpha1PipelineSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V1alpha1PipelineFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V1alpha1PipelineFluent.SpecNested<A> withNewSpecLike(V1alpha1PipelineSpec item){
            return new SpecNestedImpl(item);
    }

    public V1alpha1PipelineFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V1alpha1PipelineFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V1alpha1PipelineSpecBuilder().build());
    }

    public V1alpha1PipelineFluent.SpecNested<A> editOrNewSpecLike(V1alpha1PipelineSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public V1alpha1PipelineStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(V1alpha1PipelineStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new V1alpha1PipelineStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public V1alpha1PipelineFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public V1alpha1PipelineFluent.StatusNested<A> withNewStatusLike(V1alpha1PipelineStatus item){
            return new StatusNestedImpl(item);
    }

    public V1alpha1PipelineFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public V1alpha1PipelineFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new V1alpha1PipelineStatusBuilder().build());
    }

    public V1alpha1PipelineFluent.StatusNested<A> editOrNewStatusLike(V1alpha1PipelineStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineFluentImpl that = (V1alpha1PipelineFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class SpecNestedImpl<N> extends V1alpha1PipelineSpecFluentImpl<V1alpha1PipelineFluent.SpecNested<N>> implements V1alpha1PipelineFluent.SpecNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineSpecBuilder builder;
    
            SpecNestedImpl(V1alpha1PipelineSpec item){
                    this.builder = new V1alpha1PipelineSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V1alpha1PipelineSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends V1alpha1PipelineStatusFluentImpl<V1alpha1PipelineFluent.StatusNested<N>> implements V1alpha1PipelineFluent.StatusNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineStatusBuilder builder;
    
            StatusNestedImpl(V1alpha1PipelineStatus item){
                    this.builder = new V1alpha1PipelineStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new V1alpha1PipelineStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
