package io.alauda.devops.java.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1alpha1CodeQualityProjectInfoFluentImpl<A extends V1alpha1CodeQualityProjectInfoFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1CodeQualityProjectInfoFluent<A>{

    private String codeAddress;
    private DateTime lastAnalysisDate;
    private String projectKey;
    private String projectName;

    public V1alpha1CodeQualityProjectInfoFluentImpl(){
    }
    public V1alpha1CodeQualityProjectInfoFluentImpl(V1alpha1CodeQualityProjectInfo instance){
            this.withCodeAddress(instance.getCodeAddress());

            this.withLastAnalysisDate(instance.getLastAnalysisDate());

            this.withProjectKey(instance.getProjectKey());

            this.withProjectName(instance.getProjectName());

    }

    public String getCodeAddress(){
            return this.codeAddress;
    }

    public A withCodeAddress(String codeAddress){
            this.codeAddress=codeAddress; return (A) this;
    }

    public Boolean hasCodeAddress(){
            return this.codeAddress != null;
    }

    public A withNewCodeAddress(String arg1){
            return (A)withCodeAddress(new String(arg1));
    }

    public A withNewCodeAddress(StringBuilder arg1){
            return (A)withCodeAddress(new String(arg1));
    }

    public A withNewCodeAddress(StringBuffer arg1){
            return (A)withCodeAddress(new String(arg1));
    }

    public DateTime getLastAnalysisDate(){
            return this.lastAnalysisDate;
    }

    public A withLastAnalysisDate(DateTime lastAnalysisDate){
            this.lastAnalysisDate=lastAnalysisDate; return (A) this;
    }

    public Boolean hasLastAnalysisDate(){
            return this.lastAnalysisDate != null;
    }

    public A withNewLastAnalysisDate(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastAnalysisDate(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastAnalysisDate(Object arg0){
            return (A)withLastAnalysisDate(new DateTime(arg0));
    }

    public A withNewLastAnalysisDate(long arg0){
            return (A)withLastAnalysisDate(new DateTime(arg0));
    }

    public String getProjectKey(){
            return this.projectKey;
    }

    public A withProjectKey(String projectKey){
            this.projectKey=projectKey; return (A) this;
    }

    public Boolean hasProjectKey(){
            return this.projectKey != null;
    }

    public A withNewProjectKey(String arg1){
            return (A)withProjectKey(new String(arg1));
    }

    public A withNewProjectKey(StringBuilder arg1){
            return (A)withProjectKey(new String(arg1));
    }

    public A withNewProjectKey(StringBuffer arg1){
            return (A)withProjectKey(new String(arg1));
    }

    public String getProjectName(){
            return this.projectName;
    }

    public A withProjectName(String projectName){
            this.projectName=projectName; return (A) this;
    }

    public Boolean hasProjectName(){
            return this.projectName != null;
    }

    public A withNewProjectName(String arg1){
            return (A)withProjectName(new String(arg1));
    }

    public A withNewProjectName(StringBuilder arg1){
            return (A)withProjectName(new String(arg1));
    }

    public A withNewProjectName(StringBuffer arg1){
            return (A)withProjectName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1CodeQualityProjectInfoFluentImpl that = (V1alpha1CodeQualityProjectInfoFluentImpl) o;
            if (codeAddress != null ? !codeAddress.equals(that.codeAddress) :that.codeAddress != null) return false;
            if (lastAnalysisDate != null ? !lastAnalysisDate.equals(that.lastAnalysisDate) :that.lastAnalysisDate != null) return false;
            if (projectKey != null ? !projectKey.equals(that.projectKey) :that.projectKey != null) return false;
            if (projectName != null ? !projectName.equals(that.projectName) :that.projectName != null) return false;
            return true;
    }




}
