package io.alauda.devops.java.client.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.zjsonpatch.JsonDiff;
import io.kubernetes.client.JSON;

import java.io.IOException;

public class PatchGenerator {

    private JSON json = new JSON();
    private ObjectMapper patchMapper = new ObjectMapper();

    public <ApiType> String generatePatchBetween(ApiType current, ApiType updated) throws IOException {
        // JsonDiff use Jackson to serialize and de-serialize object, but our generated codes use Gson, so we need to convert to json string first.
        String currentJsonStr = json.serialize(current);
        String updatedJsonStr = json.serialize(updated);

        JsonNode diff = JsonDiff.asJson(patchMapper.readTree(currentJsonStr), patchMapper.readTree(updatedJsonStr));

        return patchMapper.writeValueAsString(diff);
    }

}
