package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ProjectManagementSpecBuilder extends V1alpha1ProjectManagementSpecFluentImpl<V1alpha1ProjectManagementSpecBuilder> implements VisitableBuilder<V1alpha1ProjectManagementSpec,V1alpha1ProjectManagementSpecBuilder>{

    V1alpha1ProjectManagementSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ProjectManagementSpecBuilder(){
            this(true);
    }
    public V1alpha1ProjectManagementSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ProjectManagementSpec(), validationEnabled);
    }
    public V1alpha1ProjectManagementSpecBuilder(V1alpha1ProjectManagementSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ProjectManagementSpecBuilder(V1alpha1ProjectManagementSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ProjectManagementSpec(), validationEnabled);
    }
    public V1alpha1ProjectManagementSpecBuilder(V1alpha1ProjectManagementSpecFluent<?> fluent,V1alpha1ProjectManagementSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ProjectManagementSpecBuilder(V1alpha1ProjectManagementSpecFluent<?> fluent,V1alpha1ProjectManagementSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttp(instance.getHttp());

            fluent.withSecret(instance.getSecret());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ProjectManagementSpecBuilder(V1alpha1ProjectManagementSpec instance){
            this(instance,true);
    }
    public V1alpha1ProjectManagementSpecBuilder(V1alpha1ProjectManagementSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttp(instance.getHttp());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ProjectManagementSpec build(){
            V1alpha1ProjectManagementSpec buildable = new V1alpha1ProjectManagementSpec();
            buildable.setHttp(fluent.getHttp());
            buildable.setSecret(fluent.getSecret());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ProjectManagementSpecBuilder that = (V1alpha1ProjectManagementSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
