package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ProjectManagementBindingSpecBuilder extends V1alpha1ProjectManagementBindingSpecFluentImpl<V1alpha1ProjectManagementBindingSpecBuilder> implements VisitableBuilder<V1alpha1ProjectManagementBindingSpec,V1alpha1ProjectManagementBindingSpecBuilder>{

    V1alpha1ProjectManagementBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ProjectManagementBindingSpecBuilder(){
            this(true);
    }
    public V1alpha1ProjectManagementBindingSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ProjectManagementBindingSpec(), validationEnabled);
    }
    public V1alpha1ProjectManagementBindingSpecBuilder(V1alpha1ProjectManagementBindingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ProjectManagementBindingSpecBuilder(V1alpha1ProjectManagementBindingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ProjectManagementBindingSpec(), validationEnabled);
    }
    public V1alpha1ProjectManagementBindingSpecBuilder(V1alpha1ProjectManagementBindingSpecFluent<?> fluent,V1alpha1ProjectManagementBindingSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ProjectManagementBindingSpecBuilder(V1alpha1ProjectManagementBindingSpecFluent<?> fluent,V1alpha1ProjectManagementBindingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProjectManagement(instance.getProjectManagement());

            fluent.withProjectManagementProjectInfos(instance.getProjectManagementProjectInfos());

            fluent.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ProjectManagementBindingSpecBuilder(V1alpha1ProjectManagementBindingSpec instance){
            this(instance,true);
    }
    public V1alpha1ProjectManagementBindingSpecBuilder(V1alpha1ProjectManagementBindingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProjectManagement(instance.getProjectManagement());

            this.withProjectManagementProjectInfos(instance.getProjectManagementProjectInfos());

            this.withSecret(instance.getSecret());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ProjectManagementBindingSpec build(){
            V1alpha1ProjectManagementBindingSpec buildable = new V1alpha1ProjectManagementBindingSpec();
            buildable.setProjectManagement(fluent.getProjectManagement());
            buildable.setProjectManagementProjectInfos(fluent.getProjectManagementProjectInfos());
            buildable.setSecret(fluent.getSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ProjectManagementBindingSpecBuilder that = (V1alpha1ProjectManagementBindingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
