package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ProjectManagementBindingReplicaTemplateBuilder extends V1alpha1ProjectManagementBindingReplicaTemplateFluentImpl<V1alpha1ProjectManagementBindingReplicaTemplateBuilder> implements VisitableBuilder<V1alpha1ProjectManagementBindingReplicaTemplate,V1alpha1ProjectManagementBindingReplicaTemplateBuilder>{

    V1alpha1ProjectManagementBindingReplicaTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ProjectManagementBindingReplicaTemplateBuilder(){
            this(true);
    }
    public V1alpha1ProjectManagementBindingReplicaTemplateBuilder(Boolean validationEnabled){
            this(new V1alpha1ProjectManagementBindingReplicaTemplate(), validationEnabled);
    }
    public V1alpha1ProjectManagementBindingReplicaTemplateBuilder(V1alpha1ProjectManagementBindingReplicaTemplateFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ProjectManagementBindingReplicaTemplateBuilder(V1alpha1ProjectManagementBindingReplicaTemplateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ProjectManagementBindingReplicaTemplate(), validationEnabled);
    }
    public V1alpha1ProjectManagementBindingReplicaTemplateBuilder(V1alpha1ProjectManagementBindingReplicaTemplateFluent<?> fluent,V1alpha1ProjectManagementBindingReplicaTemplate instance){
            this(fluent, instance, true);
    }
    public V1alpha1ProjectManagementBindingReplicaTemplateBuilder(V1alpha1ProjectManagementBindingReplicaTemplateFluent<?> fluent,V1alpha1ProjectManagementBindingReplicaTemplate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProjects(instance.getProjects());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ProjectManagementBindingReplicaTemplateBuilder(V1alpha1ProjectManagementBindingReplicaTemplate instance){
            this(instance,true);
    }
    public V1alpha1ProjectManagementBindingReplicaTemplateBuilder(V1alpha1ProjectManagementBindingReplicaTemplate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProjects(instance.getProjects());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ProjectManagementBindingReplicaTemplate build(){
            V1alpha1ProjectManagementBindingReplicaTemplate buildable = new V1alpha1ProjectManagementBindingReplicaTemplate();
            buildable.setProjects(fluent.getProjects());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ProjectManagementBindingReplicaTemplateBuilder that = (V1alpha1ProjectManagementBindingReplicaTemplateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
