package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateTaskBuilder extends V1alpha1PipelineTemplateTaskFluentImpl<V1alpha1PipelineTemplateTaskBuilder> implements VisitableBuilder<V1alpha1PipelineTemplateTask,V1alpha1PipelineTemplateTaskBuilder>{

    V1alpha1PipelineTemplateTaskFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineTemplateTaskBuilder(){
            this(true);
    }
    public V1alpha1PipelineTemplateTaskBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineTemplateTask(), validationEnabled);
    }
    public V1alpha1PipelineTemplateTaskBuilder(V1alpha1PipelineTemplateTaskFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineTemplateTaskBuilder(V1alpha1PipelineTemplateTaskFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineTemplateTask(), validationEnabled);
    }
    public V1alpha1PipelineTemplateTaskBuilder(V1alpha1PipelineTemplateTaskFluent<?> fluent,V1alpha1PipelineTemplateTask instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineTemplateTaskBuilder(V1alpha1PipelineTemplateTaskFluent<?> fluent,V1alpha1PipelineTemplateTask instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAgent(instance.getAgent());

            fluent.withApprove(instance.getApprove());

            fluent.withConditions(instance.getConditions());

            fluent.withDisplay(instance.getDisplay());

            fluent.withEnvironments(instance.getEnvironments());

            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            fluent.withOptions(instance.getOptions());

            fluent.withRelation(instance.getRelation());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineTemplateTaskBuilder(V1alpha1PipelineTemplateTask instance){
            this(instance,true);
    }
    public V1alpha1PipelineTemplateTaskBuilder(V1alpha1PipelineTemplateTask instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAgent(instance.getAgent());

            this.withApprove(instance.getApprove());

            this.withConditions(instance.getConditions());

            this.withDisplay(instance.getDisplay());

            this.withEnvironments(instance.getEnvironments());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withOptions(instance.getOptions());

            this.withRelation(instance.getRelation());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineTemplateTask build(){
            V1alpha1PipelineTemplateTask buildable = new V1alpha1PipelineTemplateTask();
            buildable.setAgent(fluent.getAgent());
            buildable.setApprove(fluent.getApprove());
            buildable.setConditions(fluent.getConditions());
            buildable.setDisplay(fluent.getDisplay());
            buildable.setEnvironments(fluent.getEnvironments());
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            buildable.setOptions(fluent.getOptions());
            buildable.setRelation(fluent.getRelation());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateTaskBuilder that = (V1alpha1PipelineTemplateTaskBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
