package io.alauda.devops.java.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.alauda.devops.java.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import org.joda.time.DateTime;
import io.alauda.devops.java.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1PipelineTemplateSyncStatusFluentImpl<A extends V1alpha1PipelineTemplateSyncStatusFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTemplateSyncStatusFluent<A>{

    private String commitID;
    private List<V1alpha1PipelineTemplateSyncConditionBuilder> conditions;
    private DateTime endTime;
    private String error;
    private String message;
    private String phase;
    private DateTime startTime;

    public V1alpha1PipelineTemplateSyncStatusFluentImpl(){
    }
    public V1alpha1PipelineTemplateSyncStatusFluentImpl(V1alpha1PipelineTemplateSyncStatus instance){
            this.withCommitID(instance.getCommitID());

            this.withConditions(instance.getConditions());

            this.withEndTime(instance.getEndTime());

            this.withError(instance.getError());

            this.withMessage(instance.getMessage());

            this.withPhase(instance.getPhase());

            this.withStartTime(instance.getStartTime());

    }

    public String getCommitID(){
            return this.commitID;
    }

    public A withCommitID(String commitID){
            this.commitID=commitID; return (A) this;
    }

    public Boolean hasCommitID(){
            return this.commitID != null;
    }

    public A withNewCommitID(String arg1){
            return (A)withCommitID(new String(arg1));
    }

    public A withNewCommitID(StringBuilder arg1){
            return (A)withCommitID(new String(arg1));
    }

    public A withNewCommitID(StringBuffer arg1){
            return (A)withCommitID(new String(arg1));
    }

    public A addToConditions(int index,V1alpha1PipelineTemplateSyncCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1PipelineTemplateSyncConditionBuilder>();}
            V1alpha1PipelineTemplateSyncConditionBuilder builder = new V1alpha1PipelineTemplateSyncConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1alpha1PipelineTemplateSyncCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1PipelineTemplateSyncConditionBuilder>();}
            V1alpha1PipelineTemplateSyncConditionBuilder builder = new V1alpha1PipelineTemplateSyncConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1alpha1PipelineTemplateSyncCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1PipelineTemplateSyncConditionBuilder>();}
            for (V1alpha1PipelineTemplateSyncCondition item : items) {V1alpha1PipelineTemplateSyncConditionBuilder builder = new V1alpha1PipelineTemplateSyncConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1alpha1PipelineTemplateSyncCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1alpha1PipelineTemplateSyncConditionBuilder>();}
            for (V1alpha1PipelineTemplateSyncCondition item : items) {V1alpha1PipelineTemplateSyncConditionBuilder builder = new V1alpha1PipelineTemplateSyncConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1alpha1PipelineTemplateSyncCondition... items){
            for (V1alpha1PipelineTemplateSyncCondition item : items) {V1alpha1PipelineTemplateSyncConditionBuilder builder = new V1alpha1PipelineTemplateSyncConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1alpha1PipelineTemplateSyncCondition> items){
            for (V1alpha1PipelineTemplateSyncCondition item : items) {V1alpha1PipelineTemplateSyncConditionBuilder builder = new V1alpha1PipelineTemplateSyncConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineTemplateSyncCondition> getConditions(){
            return build(conditions);
    }

    public List<V1alpha1PipelineTemplateSyncCondition> buildConditions(){
            return build(conditions);
    }

    public V1alpha1PipelineTemplateSyncCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1alpha1PipelineTemplateSyncCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1alpha1PipelineTemplateSyncCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1alpha1PipelineTemplateSyncCondition buildMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateSyncConditionBuilder> predicate){
            for (V1alpha1PipelineTemplateSyncConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateSyncConditionBuilder> predicate){
            for (V1alpha1PipelineTemplateSyncConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<V1alpha1PipelineTemplateSyncCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1alpha1PipelineTemplateSyncConditionBuilder>(); for (V1alpha1PipelineTemplateSyncCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1alpha1PipelineTemplateSyncCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1alpha1PipelineTemplateSyncCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<A> addNewConditionLike(V1alpha1PipelineTemplateSyncCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1alpha1PipelineTemplateSyncCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<A> editMatchingCondition(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateSyncConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public DateTime getEndTime(){
            return this.endTime;
    }

    public A withEndTime(DateTime endTime){
            this.endTime=endTime; return (A) this;
    }

    public Boolean hasEndTime(){
            return this.endTime != null;
    }

    public A withNewEndTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withEndTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewEndTime(Object arg0){
            return (A)withEndTime(new DateTime(arg0));
    }

    public A withNewEndTime(long arg0){
            return (A)withEndTime(new DateTime(arg0));
    }

    public String getError(){
            return this.error;
    }

    public A withError(String error){
            this.error=error; return (A) this;
    }

    public Boolean hasError(){
            return this.error != null;
    }

    public A withNewError(String arg1){
            return (A)withError(new String(arg1));
    }

    public A withNewError(StringBuilder arg1){
            return (A)withError(new String(arg1));
    }

    public A withNewError(StringBuffer arg1){
            return (A)withError(new String(arg1));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public Boolean hasPhase(){
            return this.phase != null;
    }

    public A withNewPhase(String arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1){
            return (A)withPhase(new String(arg1));
    }

    public DateTime getStartTime(){
            return this.startTime;
    }

    public A withStartTime(DateTime startTime){
            this.startTime=startTime; return (A) this;
    }

    public Boolean hasStartTime(){
            return this.startTime != null;
    }

    public A withNewStartTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withStartTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewStartTime(Object arg0){
            return (A)withStartTime(new DateTime(arg0));
    }

    public A withNewStartTime(long arg0){
            return (A)withStartTime(new DateTime(arg0));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateSyncStatusFluentImpl that = (V1alpha1PipelineTemplateSyncStatusFluentImpl) o;
            if (commitID != null ? !commitID.equals(that.commitID) :that.commitID != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (endTime != null ? !endTime.equals(that.endTime) :that.endTime != null) return false;
            if (error != null ? !error.equals(that.error) :that.error != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V1alpha1PipelineTemplateSyncConditionFluentImpl<V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<N>> implements V1alpha1PipelineTemplateSyncStatusFluent.ConditionsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateSyncConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1alpha1PipelineTemplateSyncCondition item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineTemplateSyncConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineTemplateSyncConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSyncStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
