package io.alauda.devops.java.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.alauda.devops.java.client.fluent.Predicate;
import java.util.LinkedHashMap;
import io.alauda.devops.java.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.alauda.devops.java.client.fluent.Nested;
import java.lang.Deprecated;
import java.lang.StringBuffer;

public class V1alpha1PipelineTemplateSpecFluentImpl<A extends V1alpha1PipelineTemplateSpecFluent<A>> extends io.alauda.devops.java.client.fluent.BaseFluent<A> implements V1alpha1PipelineTemplateSpecFluent<A>{

    private V1alpha1JenkinsAgentBuilder agent;
    private List<V1alpha1PipelineTemplateArgumentGroupBuilder> arguments;
    private String engine;
    private List<V1alpha1PipelineEnvironmentBuilder> environments;
    private V1alpha1PipelineOptionsBuilder options;
    private List<V1alpha1PipelineParameterBuilder> parameters;
    private Map<String,List<V1alpha1PipelineTemplateTask>> post;
    private List<V1alpha1PipelineStageBuilder> stages;
    private V1alpha1PipelineTriggersBuilder triggers;
    private V1alpha1ConstValuesBuilder values;
    private Boolean withSCM;

    public V1alpha1PipelineTemplateSpecFluentImpl(){
    }
    public V1alpha1PipelineTemplateSpecFluentImpl(V1alpha1PipelineTemplateSpec instance){
            this.withAgent(instance.getAgent());

            this.withArguments(instance.getArguments());

            this.withEngine(instance.getEngine());

            this.withEnvironments(instance.getEnvironments());

            this.withOptions(instance.getOptions());

            this.withParameters(instance.getParameters());

            this.withPost(instance.getPost());

            this.withStages(instance.getStages());

            this.withTriggers(instance.getTriggers());

            this.withValues(instance.getValues());

            this.withWithSCM(instance.isWithSCM());

    }

    
/**
 * This method has been deprecated, please use method buildAgent instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1JenkinsAgent getAgent(){
            return this.agent!=null?this.agent.build():null;
    }

    public V1alpha1JenkinsAgent buildAgent(){
            return this.agent!=null?this.agent.build():null;
    }

    public A withAgent(V1alpha1JenkinsAgent agent){
            _visitables.get("agent").remove(this.agent);
            if (agent!=null){ this.agent= new V1alpha1JenkinsAgentBuilder(agent); _visitables.get("agent").add(this.agent);} return (A) this;
    }

    public Boolean hasAgent(){
            return this.agent != null;
    }

    public V1alpha1PipelineTemplateSpecFluent.AgentNested<A> withNewAgent(){
            return new AgentNestedImpl();
    }

    public V1alpha1PipelineTemplateSpecFluent.AgentNested<A> withNewAgentLike(V1alpha1JenkinsAgent item){
            return new AgentNestedImpl(item);
    }

    public V1alpha1PipelineTemplateSpecFluent.AgentNested<A> editAgent(){
            return withNewAgentLike(getAgent());
    }

    public V1alpha1PipelineTemplateSpecFluent.AgentNested<A> editOrNewAgent(){
            return withNewAgentLike(getAgent() != null ? getAgent(): new V1alpha1JenkinsAgentBuilder().build());
    }

    public V1alpha1PipelineTemplateSpecFluent.AgentNested<A> editOrNewAgentLike(V1alpha1JenkinsAgent item){
            return withNewAgentLike(getAgent() != null ? getAgent(): item);
    }

    public A addToArguments(int index,V1alpha1PipelineTemplateArgumentGroup item){
            if (this.arguments == null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentGroupBuilder>();}
            V1alpha1PipelineTemplateArgumentGroupBuilder builder = new V1alpha1PipelineTemplateArgumentGroupBuilder(item);_visitables.get("arguments").add(index >= 0 ? index : _visitables.get("arguments").size(), builder);this.arguments.add(index >= 0 ? index : arguments.size(), builder); return (A)this;
    }

    public A setToArguments(int index,V1alpha1PipelineTemplateArgumentGroup item){
            if (this.arguments == null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentGroupBuilder>();}
            V1alpha1PipelineTemplateArgumentGroupBuilder builder = new V1alpha1PipelineTemplateArgumentGroupBuilder(item);
            if (index < 0 || index >= _visitables.get("arguments").size()) { _visitables.get("arguments").add(builder); } else { _visitables.get("arguments").set(index, builder);}
            if (index < 0 || index >= arguments.size()) { arguments.add(builder); } else { arguments.set(index, builder);}
             return (A)this;
    }

    public A addToArguments(V1alpha1PipelineTemplateArgumentGroup... items){
            if (this.arguments == null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentGroupBuilder>();}
            for (V1alpha1PipelineTemplateArgumentGroup item : items) {V1alpha1PipelineTemplateArgumentGroupBuilder builder = new V1alpha1PipelineTemplateArgumentGroupBuilder(item);_visitables.get("arguments").add(builder);this.arguments.add(builder);} return (A)this;
    }

    public A addAllToArguments(Collection<V1alpha1PipelineTemplateArgumentGroup> items){
            if (this.arguments == null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentGroupBuilder>();}
            for (V1alpha1PipelineTemplateArgumentGroup item : items) {V1alpha1PipelineTemplateArgumentGroupBuilder builder = new V1alpha1PipelineTemplateArgumentGroupBuilder(item);_visitables.get("arguments").add(builder);this.arguments.add(builder);} return (A)this;
    }

    public A removeFromArguments(V1alpha1PipelineTemplateArgumentGroup... items){
            for (V1alpha1PipelineTemplateArgumentGroup item : items) {V1alpha1PipelineTemplateArgumentGroupBuilder builder = new V1alpha1PipelineTemplateArgumentGroupBuilder(item);_visitables.get("arguments").remove(builder);if (this.arguments != null) {this.arguments.remove(builder);}} return (A)this;
    }

    public A removeAllFromArguments(Collection<V1alpha1PipelineTemplateArgumentGroup> items){
            for (V1alpha1PipelineTemplateArgumentGroup item : items) {V1alpha1PipelineTemplateArgumentGroupBuilder builder = new V1alpha1PipelineTemplateArgumentGroupBuilder(item);_visitables.get("arguments").remove(builder);if (this.arguments != null) {this.arguments.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildArguments instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineTemplateArgumentGroup> getArguments(){
            return build(arguments);
    }

    public List<V1alpha1PipelineTemplateArgumentGroup> buildArguments(){
            return build(arguments);
    }

    public V1alpha1PipelineTemplateArgumentGroup buildArgument(int index){
            return this.arguments.get(index).build();
    }

    public V1alpha1PipelineTemplateArgumentGroup buildFirstArgument(){
            return this.arguments.get(0).build();
    }

    public V1alpha1PipelineTemplateArgumentGroup buildLastArgument(){
            return this.arguments.get(arguments.size() - 1).build();
    }

    public V1alpha1PipelineTemplateArgumentGroup buildMatchingArgument(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateArgumentGroupBuilder> predicate){
            for (V1alpha1PipelineTemplateArgumentGroupBuilder item: arguments) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingArgument(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateArgumentGroupBuilder> predicate){
            for (V1alpha1PipelineTemplateArgumentGroupBuilder item: arguments) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withArguments(List<V1alpha1PipelineTemplateArgumentGroup> arguments){
            if (this.arguments != null) { _visitables.get("arguments").removeAll(this.arguments);}
            if (arguments != null) {this.arguments = new ArrayList<V1alpha1PipelineTemplateArgumentGroupBuilder>(); for (V1alpha1PipelineTemplateArgumentGroup item : arguments){this.addToArguments(item);}} else { this.arguments = null;} return (A) this;
    }

    public A withArguments(V1alpha1PipelineTemplateArgumentGroup... arguments){
            if (this.arguments != null) {this.arguments.clear();}
            if (arguments != null) {for (V1alpha1PipelineTemplateArgumentGroup item :arguments){ this.addToArguments(item);}} return (A) this;
    }

    public Boolean hasArguments(){
            return arguments != null && !arguments.isEmpty();
    }

    public V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<A> addNewArgument(){
            return new ArgumentsNestedImpl();
    }

    public V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<A> addNewArgumentLike(V1alpha1PipelineTemplateArgumentGroup item){
            return new ArgumentsNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<A> setNewArgumentLike(int index,V1alpha1PipelineTemplateArgumentGroup item){
            return new ArgumentsNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<A> editArgument(int index){
            if (arguments.size() <= index) throw new RuntimeException("Can't edit arguments. Index exceeds size.");
            return setNewArgumentLike(index, buildArgument(index));
    }

    public V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<A> editFirstArgument(){
            if (arguments.size() == 0) throw new RuntimeException("Can't edit first arguments. The list is empty.");
            return setNewArgumentLike(0, buildArgument(0));
    }

    public V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<A> editLastArgument(){
            int index = arguments.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last arguments. The list is empty.");
            return setNewArgumentLike(index, buildArgument(index));
    }

    public V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<A> editMatchingArgument(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineTemplateArgumentGroupBuilder> predicate){
            int index = -1;
            for (int i=0;i<arguments.size();i++) { 
            if (predicate.apply(arguments.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching arguments. No match found.");
            return setNewArgumentLike(index, buildArgument(index));
    }

    public String getEngine(){
            return this.engine;
    }

    public A withEngine(String engine){
            this.engine=engine; return (A) this;
    }

    public Boolean hasEngine(){
            return this.engine != null;
    }

    public A withNewEngine(String arg1){
            return (A)withEngine(new String(arg1));
    }

    public A withNewEngine(StringBuilder arg1){
            return (A)withEngine(new String(arg1));
    }

    public A withNewEngine(StringBuffer arg1){
            return (A)withEngine(new String(arg1));
    }

    public A addToEnvironments(int index,V1alpha1PipelineEnvironment item){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(index >= 0 ? index : _visitables.get("environments").size(), builder);this.environments.add(index >= 0 ? index : environments.size(), builder); return (A)this;
    }

    public A setToEnvironments(int index,V1alpha1PipelineEnvironment item){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);
            if (index < 0 || index >= _visitables.get("environments").size()) { _visitables.get("environments").add(builder); } else { _visitables.get("environments").set(index, builder);}
            if (index < 0 || index >= environments.size()) { environments.add(builder); } else { environments.set(index, builder);}
             return (A)this;
    }

    public A addToEnvironments(V1alpha1PipelineEnvironment... items){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(builder);this.environments.add(builder);} return (A)this;
    }

    public A addAllToEnvironments(Collection<V1alpha1PipelineEnvironment> items){
            if (this.environments == null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>();}
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").add(builder);this.environments.add(builder);} return (A)this;
    }

    public A removeFromEnvironments(V1alpha1PipelineEnvironment... items){
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").remove(builder);if (this.environments != null) {this.environments.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnvironments(Collection<V1alpha1PipelineEnvironment> items){
            for (V1alpha1PipelineEnvironment item : items) {V1alpha1PipelineEnvironmentBuilder builder = new V1alpha1PipelineEnvironmentBuilder(item);_visitables.get("environments").remove(builder);if (this.environments != null) {this.environments.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEnvironments instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineEnvironment> getEnvironments(){
            return build(environments);
    }

    public List<V1alpha1PipelineEnvironment> buildEnvironments(){
            return build(environments);
    }

    public V1alpha1PipelineEnvironment buildEnvironment(int index){
            return this.environments.get(index).build();
    }

    public V1alpha1PipelineEnvironment buildFirstEnvironment(){
            return this.environments.get(0).build();
    }

    public V1alpha1PipelineEnvironment buildLastEnvironment(){
            return this.environments.get(environments.size() - 1).build();
    }

    public V1alpha1PipelineEnvironment buildMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            for (V1alpha1PipelineEnvironmentBuilder item: environments) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            for (V1alpha1PipelineEnvironmentBuilder item: environments) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withEnvironments(List<V1alpha1PipelineEnvironment> environments){
            if (this.environments != null) { _visitables.get("environments").removeAll(this.environments);}
            if (environments != null) {this.environments = new ArrayList<V1alpha1PipelineEnvironmentBuilder>(); for (V1alpha1PipelineEnvironment item : environments){this.addToEnvironments(item);}} else { this.environments = null;} return (A) this;
    }

    public A withEnvironments(V1alpha1PipelineEnvironment... environments){
            if (this.environments != null) {this.environments.clear();}
            if (environments != null) {for (V1alpha1PipelineEnvironment item :environments){ this.addToEnvironments(item);}} return (A) this;
    }

    public Boolean hasEnvironments(){
            return environments != null && !environments.isEmpty();
    }

    public V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<A> addNewEnvironment(){
            return new EnvironmentsNestedImpl();
    }

    public V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<A> addNewEnvironmentLike(V1alpha1PipelineEnvironment item){
            return new EnvironmentsNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<A> setNewEnvironmentLike(int index,V1alpha1PipelineEnvironment item){
            return new EnvironmentsNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<A> editEnvironment(int index){
            if (environments.size() <= index) throw new RuntimeException("Can't edit environments. Index exceeds size.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<A> editFirstEnvironment(){
            if (environments.size() == 0) throw new RuntimeException("Can't edit first environments. The list is empty.");
            return setNewEnvironmentLike(0, buildEnvironment(0));
    }

    public V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<A> editLastEnvironment(){
            int index = environments.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last environments. The list is empty.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    public V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<A> editMatchingEnvironment(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineEnvironmentBuilder> predicate){
            int index = -1;
            for (int i=0;i<environments.size();i++) { 
            if (predicate.apply(environments.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching environments. No match found.");
            return setNewEnvironmentLike(index, buildEnvironment(index));
    }

    
/**
 * This method has been deprecated, please use method buildOptions instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineOptions getOptions(){
            return this.options!=null?this.options.build():null;
    }

    public V1alpha1PipelineOptions buildOptions(){
            return this.options!=null?this.options.build():null;
    }

    public A withOptions(V1alpha1PipelineOptions options){
            _visitables.get("options").remove(this.options);
            if (options!=null){ this.options= new V1alpha1PipelineOptionsBuilder(options); _visitables.get("options").add(this.options);} return (A) this;
    }

    public Boolean hasOptions(){
            return this.options != null;
    }

    public V1alpha1PipelineTemplateSpecFluent.OptionsNested<A> withNewOptions(){
            return new OptionsNestedImpl();
    }

    public V1alpha1PipelineTemplateSpecFluent.OptionsNested<A> withNewOptionsLike(V1alpha1PipelineOptions item){
            return new OptionsNestedImpl(item);
    }

    public V1alpha1PipelineTemplateSpecFluent.OptionsNested<A> editOptions(){
            return withNewOptionsLike(getOptions());
    }

    public V1alpha1PipelineTemplateSpecFluent.OptionsNested<A> editOrNewOptions(){
            return withNewOptionsLike(getOptions() != null ? getOptions(): new V1alpha1PipelineOptionsBuilder().build());
    }

    public V1alpha1PipelineTemplateSpecFluent.OptionsNested<A> editOrNewOptionsLike(V1alpha1PipelineOptions item){
            return withNewOptionsLike(getOptions() != null ? getOptions(): item);
    }

    public A addToParameters(int index,V1alpha1PipelineParameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(index >= 0 ? index : _visitables.get("parameters").size(), builder);this.parameters.add(index >= 0 ? index : parameters.size(), builder); return (A)this;
    }

    public A setToParameters(int index,V1alpha1PipelineParameter item){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);
            if (index < 0 || index >= _visitables.get("parameters").size()) { _visitables.get("parameters").add(builder); } else { _visitables.get("parameters").set(index, builder);}
            if (index < 0 || index >= parameters.size()) { parameters.add(builder); } else { parameters.set(index, builder);}
             return (A)this;
    }

    public A addToParameters(V1alpha1PipelineParameter... items){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A addAllToParameters(Collection<V1alpha1PipelineParameter> items){
            if (this.parameters == null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>();}
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").add(builder);this.parameters.add(builder);} return (A)this;
    }

    public A removeFromParameters(V1alpha1PipelineParameter... items){
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    public A removeAllFromParameters(Collection<V1alpha1PipelineParameter> items){
            for (V1alpha1PipelineParameter item : items) {V1alpha1PipelineParameterBuilder builder = new V1alpha1PipelineParameterBuilder(item);_visitables.get("parameters").remove(builder);if (this.parameters != null) {this.parameters.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildParameters instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineParameter> getParameters(){
            return build(parameters);
    }

    public List<V1alpha1PipelineParameter> buildParameters(){
            return build(parameters);
    }

    public V1alpha1PipelineParameter buildParameter(int index){
            return this.parameters.get(index).build();
    }

    public V1alpha1PipelineParameter buildFirstParameter(){
            return this.parameters.get(0).build();
    }

    public V1alpha1PipelineParameter buildLastParameter(){
            return this.parameters.get(parameters.size() - 1).build();
    }

    public V1alpha1PipelineParameter buildMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            for (V1alpha1PipelineParameterBuilder item: parameters) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            for (V1alpha1PipelineParameterBuilder item: parameters) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withParameters(List<V1alpha1PipelineParameter> parameters){
            if (this.parameters != null) { _visitables.get("parameters").removeAll(this.parameters);}
            if (parameters != null) {this.parameters = new ArrayList<V1alpha1PipelineParameterBuilder>(); for (V1alpha1PipelineParameter item : parameters){this.addToParameters(item);}} else { this.parameters = null;} return (A) this;
    }

    public A withParameters(V1alpha1PipelineParameter... parameters){
            if (this.parameters != null) {this.parameters.clear();}
            if (parameters != null) {for (V1alpha1PipelineParameter item :parameters){ this.addToParameters(item);}} return (A) this;
    }

    public Boolean hasParameters(){
            return parameters != null && !parameters.isEmpty();
    }

    public V1alpha1PipelineTemplateSpecFluent.ParametersNested<A> addNewParameter(){
            return new ParametersNestedImpl();
    }

    public V1alpha1PipelineTemplateSpecFluent.ParametersNested<A> addNewParameterLike(V1alpha1PipelineParameter item){
            return new ParametersNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateSpecFluent.ParametersNested<A> setNewParameterLike(int index,V1alpha1PipelineParameter item){
            return new ParametersNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateSpecFluent.ParametersNested<A> editParameter(int index){
            if (parameters.size() <= index) throw new RuntimeException("Can't edit parameters. Index exceeds size.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public V1alpha1PipelineTemplateSpecFluent.ParametersNested<A> editFirstParameter(){
            if (parameters.size() == 0) throw new RuntimeException("Can't edit first parameters. The list is empty.");
            return setNewParameterLike(0, buildParameter(0));
    }

    public V1alpha1PipelineTemplateSpecFluent.ParametersNested<A> editLastParameter(){
            int index = parameters.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last parameters. The list is empty.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public V1alpha1PipelineTemplateSpecFluent.ParametersNested<A> editMatchingParameter(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineParameterBuilder> predicate){
            int index = -1;
            for (int i=0;i<parameters.size();i++) { 
            if (predicate.apply(parameters.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching parameters. No match found.");
            return setNewParameterLike(index, buildParameter(index));
    }

    public A addToPost(String key,List<V1alpha1PipelineTemplateTask> value){
            if(this.post == null && key != null && value != null) { this.post = new LinkedHashMap<String,List<V1alpha1PipelineTemplateTask>>(); }
            if(key != null && value != null) {this.post.put(key, value);} return (A)this;
    }

    public A addToPost(Map<String,List<V1alpha1PipelineTemplateTask>> map){
            if(this.post == null && map != null) { this.post = new LinkedHashMap<String,List<V1alpha1PipelineTemplateTask>>(); }
            if(map != null) { this.post.putAll(map);} return (A)this;
    }

    public A removeFromPost(String key){
            if(this.post == null) { return (A) this; }
            if(key != null && this.post != null) {this.post.remove(key);} return (A)this;
    }

    public A removeFromPost(Map<String,List<V1alpha1PipelineTemplateTask>> map){
            if(this.post == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.post != null){this.post.remove(key);}}} return (A)this;
    }

    public Map<String,List<V1alpha1PipelineTemplateTask>> getPost(){
            return this.post;
    }

    public A withPost(Map<String,List<V1alpha1PipelineTemplateTask>> post){
            if (post == null) { this.post =  null;} else {this.post = new LinkedHashMap<String,List<V1alpha1PipelineTemplateTask>>(post);} return (A) this;
    }

    public Boolean hasPost(){
            return this.post != null;
    }

    public A addToStages(int index,V1alpha1PipelineStage item){
            if (this.stages == null) {this.stages = new ArrayList<V1alpha1PipelineStageBuilder>();}
            V1alpha1PipelineStageBuilder builder = new V1alpha1PipelineStageBuilder(item);_visitables.get("stages").add(index >= 0 ? index : _visitables.get("stages").size(), builder);this.stages.add(index >= 0 ? index : stages.size(), builder); return (A)this;
    }

    public A setToStages(int index,V1alpha1PipelineStage item){
            if (this.stages == null) {this.stages = new ArrayList<V1alpha1PipelineStageBuilder>();}
            V1alpha1PipelineStageBuilder builder = new V1alpha1PipelineStageBuilder(item);
            if (index < 0 || index >= _visitables.get("stages").size()) { _visitables.get("stages").add(builder); } else { _visitables.get("stages").set(index, builder);}
            if (index < 0 || index >= stages.size()) { stages.add(builder); } else { stages.set(index, builder);}
             return (A)this;
    }

    public A addToStages(V1alpha1PipelineStage... items){
            if (this.stages == null) {this.stages = new ArrayList<V1alpha1PipelineStageBuilder>();}
            for (V1alpha1PipelineStage item : items) {V1alpha1PipelineStageBuilder builder = new V1alpha1PipelineStageBuilder(item);_visitables.get("stages").add(builder);this.stages.add(builder);} return (A)this;
    }

    public A addAllToStages(Collection<V1alpha1PipelineStage> items){
            if (this.stages == null) {this.stages = new ArrayList<V1alpha1PipelineStageBuilder>();}
            for (V1alpha1PipelineStage item : items) {V1alpha1PipelineStageBuilder builder = new V1alpha1PipelineStageBuilder(item);_visitables.get("stages").add(builder);this.stages.add(builder);} return (A)this;
    }

    public A removeFromStages(V1alpha1PipelineStage... items){
            for (V1alpha1PipelineStage item : items) {V1alpha1PipelineStageBuilder builder = new V1alpha1PipelineStageBuilder(item);_visitables.get("stages").remove(builder);if (this.stages != null) {this.stages.remove(builder);}} return (A)this;
    }

    public A removeAllFromStages(Collection<V1alpha1PipelineStage> items){
            for (V1alpha1PipelineStage item : items) {V1alpha1PipelineStageBuilder builder = new V1alpha1PipelineStageBuilder(item);_visitables.get("stages").remove(builder);if (this.stages != null) {this.stages.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildStages instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PipelineStage> getStages(){
            return build(stages);
    }

    public List<V1alpha1PipelineStage> buildStages(){
            return build(stages);
    }

    public V1alpha1PipelineStage buildStage(int index){
            return this.stages.get(index).build();
    }

    public V1alpha1PipelineStage buildFirstStage(){
            return this.stages.get(0).build();
    }

    public V1alpha1PipelineStage buildLastStage(){
            return this.stages.get(stages.size() - 1).build();
    }

    public V1alpha1PipelineStage buildMatchingStage(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineStageBuilder> predicate){
            for (V1alpha1PipelineStageBuilder item: stages) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingStage(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineStageBuilder> predicate){
            for (V1alpha1PipelineStageBuilder item: stages) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withStages(List<V1alpha1PipelineStage> stages){
            if (this.stages != null) { _visitables.get("stages").removeAll(this.stages);}
            if (stages != null) {this.stages = new ArrayList<V1alpha1PipelineStageBuilder>(); for (V1alpha1PipelineStage item : stages){this.addToStages(item);}} else { this.stages = null;} return (A) this;
    }

    public A withStages(V1alpha1PipelineStage... stages){
            if (this.stages != null) {this.stages.clear();}
            if (stages != null) {for (V1alpha1PipelineStage item :stages){ this.addToStages(item);}} return (A) this;
    }

    public Boolean hasStages(){
            return stages != null && !stages.isEmpty();
    }

    public V1alpha1PipelineTemplateSpecFluent.StagesNested<A> addNewStage(){
            return new StagesNestedImpl();
    }

    public V1alpha1PipelineTemplateSpecFluent.StagesNested<A> addNewStageLike(V1alpha1PipelineStage item){
            return new StagesNestedImpl(-1, item);
    }

    public V1alpha1PipelineTemplateSpecFluent.StagesNested<A> setNewStageLike(int index,V1alpha1PipelineStage item){
            return new StagesNestedImpl(index, item);
    }

    public V1alpha1PipelineTemplateSpecFluent.StagesNested<A> editStage(int index){
            if (stages.size() <= index) throw new RuntimeException("Can't edit stages. Index exceeds size.");
            return setNewStageLike(index, buildStage(index));
    }

    public V1alpha1PipelineTemplateSpecFluent.StagesNested<A> editFirstStage(){
            if (stages.size() == 0) throw new RuntimeException("Can't edit first stages. The list is empty.");
            return setNewStageLike(0, buildStage(0));
    }

    public V1alpha1PipelineTemplateSpecFluent.StagesNested<A> editLastStage(){
            int index = stages.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last stages. The list is empty.");
            return setNewStageLike(index, buildStage(index));
    }

    public V1alpha1PipelineTemplateSpecFluent.StagesNested<A> editMatchingStage(io.alauda.devops.java.client.fluent.Predicate<V1alpha1PipelineStageBuilder> predicate){
            int index = -1;
            for (int i=0;i<stages.size();i++) { 
            if (predicate.apply(stages.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching stages. No match found.");
            return setNewStageLike(index, buildStage(index));
    }

    
/**
 * This method has been deprecated, please use method buildTriggers instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1PipelineTriggers getTriggers(){
            return this.triggers!=null?this.triggers.build():null;
    }

    public V1alpha1PipelineTriggers buildTriggers(){
            return this.triggers!=null?this.triggers.build():null;
    }

    public A withTriggers(V1alpha1PipelineTriggers triggers){
            _visitables.get("triggers").remove(this.triggers);
            if (triggers!=null){ this.triggers= new V1alpha1PipelineTriggersBuilder(triggers); _visitables.get("triggers").add(this.triggers);} return (A) this;
    }

    public Boolean hasTriggers(){
            return this.triggers != null;
    }

    public V1alpha1PipelineTemplateSpecFluent.TriggersNested<A> withNewTriggers(){
            return new TriggersNestedImpl();
    }

    public V1alpha1PipelineTemplateSpecFluent.TriggersNested<A> withNewTriggersLike(V1alpha1PipelineTriggers item){
            return new TriggersNestedImpl(item);
    }

    public V1alpha1PipelineTemplateSpecFluent.TriggersNested<A> editTriggers(){
            return withNewTriggersLike(getTriggers());
    }

    public V1alpha1PipelineTemplateSpecFluent.TriggersNested<A> editOrNewTriggers(){
            return withNewTriggersLike(getTriggers() != null ? getTriggers(): new V1alpha1PipelineTriggersBuilder().build());
    }

    public V1alpha1PipelineTemplateSpecFluent.TriggersNested<A> editOrNewTriggersLike(V1alpha1PipelineTriggers item){
            return withNewTriggersLike(getTriggers() != null ? getTriggers(): item);
    }

    
/**
 * This method has been deprecated, please use method buildValues instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ConstValues getValues(){
            return this.values!=null?this.values.build():null;
    }

    public V1alpha1ConstValues buildValues(){
            return this.values!=null?this.values.build():null;
    }

    public A withValues(V1alpha1ConstValues values){
            _visitables.get("values").remove(this.values);
            if (values!=null){ this.values= new V1alpha1ConstValuesBuilder(values); _visitables.get("values").add(this.values);} return (A) this;
    }

    public Boolean hasValues(){
            return this.values != null;
    }

    public V1alpha1PipelineTemplateSpecFluent.ValuesNested<A> withNewValues(){
            return new ValuesNestedImpl();
    }

    public V1alpha1PipelineTemplateSpecFluent.ValuesNested<A> withNewValuesLike(V1alpha1ConstValues item){
            return new ValuesNestedImpl(item);
    }

    public V1alpha1PipelineTemplateSpecFluent.ValuesNested<A> editValues(){
            return withNewValuesLike(getValues());
    }

    public V1alpha1PipelineTemplateSpecFluent.ValuesNested<A> editOrNewValues(){
            return withNewValuesLike(getValues() != null ? getValues(): new V1alpha1ConstValuesBuilder().build());
    }

    public V1alpha1PipelineTemplateSpecFluent.ValuesNested<A> editOrNewValuesLike(V1alpha1ConstValues item){
            return withNewValuesLike(getValues() != null ? getValues(): item);
    }

    public Boolean isWithSCM(){
            return this.withSCM;
    }

    public A withWithSCM(Boolean withSCM){
            this.withSCM=withSCM; return (A) this;
    }

    public Boolean hasWithSCM(){
            return this.withSCM != null;
    }

    public A withNewWithSCM(String arg1){
            return (A)withWithSCM(new Boolean(arg1));
    }

    public A withNewWithSCM(boolean arg1){
            return (A)withWithSCM(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineTemplateSpecFluentImpl that = (V1alpha1PipelineTemplateSpecFluentImpl) o;
            if (agent != null ? !agent.equals(that.agent) :that.agent != null) return false;
            if (arguments != null ? !arguments.equals(that.arguments) :that.arguments != null) return false;
            if (engine != null ? !engine.equals(that.engine) :that.engine != null) return false;
            if (environments != null ? !environments.equals(that.environments) :that.environments != null) return false;
            if (options != null ? !options.equals(that.options) :that.options != null) return false;
            if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
            if (post != null ? !post.equals(that.post) :that.post != null) return false;
            if (stages != null ? !stages.equals(that.stages) :that.stages != null) return false;
            if (triggers != null ? !triggers.equals(that.triggers) :that.triggers != null) return false;
            if (values != null ? !values.equals(that.values) :that.values != null) return false;
            if (withSCM != null ? !withSCM.equals(that.withSCM) :that.withSCM != null) return false;
            return true;
    }


    public class AgentNestedImpl<N> extends V1alpha1JenkinsAgentFluentImpl<V1alpha1PipelineTemplateSpecFluent.AgentNested<N>> implements V1alpha1PipelineTemplateSpecFluent.AgentNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1JenkinsAgentBuilder builder;
    
            AgentNestedImpl(V1alpha1JenkinsAgent item){
                    this.builder = new V1alpha1JenkinsAgentBuilder(this, item);
            }
            AgentNestedImpl(){
                    this.builder = new V1alpha1JenkinsAgentBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSpecFluentImpl.this.withAgent(builder.build());
    }
    public N endAgent(){
            return and();
    }

}
    public class ArgumentsNestedImpl<N> extends V1alpha1PipelineTemplateArgumentGroupFluentImpl<V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<N>> implements V1alpha1PipelineTemplateSpecFluent.ArgumentsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTemplateArgumentGroupBuilder builder;
        private final int index;
    
            ArgumentsNestedImpl(int index,V1alpha1PipelineTemplateArgumentGroup item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineTemplateArgumentGroupBuilder(this, item);
            }
            ArgumentsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineTemplateArgumentGroupBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSpecFluentImpl.this.setToArguments(index, builder.build());
    }
    public N endArgument(){
            return and();
    }

}
    public class EnvironmentsNestedImpl<N> extends V1alpha1PipelineEnvironmentFluentImpl<V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<N>> implements V1alpha1PipelineTemplateSpecFluent.EnvironmentsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineEnvironmentBuilder builder;
        private final int index;
    
            EnvironmentsNestedImpl(int index,V1alpha1PipelineEnvironment item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineEnvironmentBuilder(this, item);
            }
            EnvironmentsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineEnvironmentBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSpecFluentImpl.this.setToEnvironments(index, builder.build());
    }
    public N endEnvironment(){
            return and();
    }

}
    public class OptionsNestedImpl<N> extends V1alpha1PipelineOptionsFluentImpl<V1alpha1PipelineTemplateSpecFluent.OptionsNested<N>> implements V1alpha1PipelineTemplateSpecFluent.OptionsNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineOptionsBuilder builder;
    
            OptionsNestedImpl(V1alpha1PipelineOptions item){
                    this.builder = new V1alpha1PipelineOptionsBuilder(this, item);
            }
            OptionsNestedImpl(){
                    this.builder = new V1alpha1PipelineOptionsBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSpecFluentImpl.this.withOptions(builder.build());
    }
    public N endOptions(){
            return and();
    }

}
    public class ParametersNestedImpl<N> extends V1alpha1PipelineParameterFluentImpl<V1alpha1PipelineTemplateSpecFluent.ParametersNested<N>> implements V1alpha1PipelineTemplateSpecFluent.ParametersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineParameterBuilder builder;
        private final int index;
    
            ParametersNestedImpl(int index,V1alpha1PipelineParameter item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineParameterBuilder(this, item);
            }
            ParametersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineParameterBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSpecFluentImpl.this.setToParameters(index, builder.build());
    }
    public N endParameter(){
            return and();
    }

}
    public class StagesNestedImpl<N> extends V1alpha1PipelineStageFluentImpl<V1alpha1PipelineTemplateSpecFluent.StagesNested<N>> implements V1alpha1PipelineTemplateSpecFluent.StagesNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineStageBuilder builder;
        private final int index;
    
            StagesNestedImpl(int index,V1alpha1PipelineStage item){
                    this.index = index;
                    this.builder = new V1alpha1PipelineStageBuilder(this, item);
            }
            StagesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PipelineStageBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSpecFluentImpl.this.setToStages(index, builder.build());
    }
    public N endStage(){
            return and();
    }

}
    public class TriggersNestedImpl<N> extends V1alpha1PipelineTriggersFluentImpl<V1alpha1PipelineTemplateSpecFluent.TriggersNested<N>> implements V1alpha1PipelineTemplateSpecFluent.TriggersNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1PipelineTriggersBuilder builder;
    
            TriggersNestedImpl(V1alpha1PipelineTriggers item){
                    this.builder = new V1alpha1PipelineTriggersBuilder(this, item);
            }
            TriggersNestedImpl(){
                    this.builder = new V1alpha1PipelineTriggersBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSpecFluentImpl.this.withTriggers(builder.build());
    }
    public N endTriggers(){
            return and();
    }

}
    public class ValuesNestedImpl<N> extends V1alpha1ConstValuesFluentImpl<V1alpha1PipelineTemplateSpecFluent.ValuesNested<N>> implements V1alpha1PipelineTemplateSpecFluent.ValuesNested<N>,io.alauda.devops.java.client.fluent.Nested<N>{

            private final V1alpha1ConstValuesBuilder builder;
    
            ValuesNestedImpl(V1alpha1ConstValues item){
                    this.builder = new V1alpha1ConstValuesBuilder(this, item);
            }
            ValuesNestedImpl(){
                    this.builder = new V1alpha1ConstValuesBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PipelineTemplateSpecFluentImpl.this.withValues(builder.build());
    }
    public N endValues(){
            return and();
    }

}


}
