package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineStrategyJenkinsBuilder extends V1alpha1PipelineStrategyJenkinsFluentImpl<V1alpha1PipelineStrategyJenkinsBuilder> implements VisitableBuilder<V1alpha1PipelineStrategyJenkins,V1alpha1PipelineStrategyJenkinsBuilder>{

    V1alpha1PipelineStrategyJenkinsFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineStrategyJenkinsBuilder(){
            this(true);
    }
    public V1alpha1PipelineStrategyJenkinsBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineStrategyJenkins(), validationEnabled);
    }
    public V1alpha1PipelineStrategyJenkinsBuilder(V1alpha1PipelineStrategyJenkinsFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineStrategyJenkinsBuilder(V1alpha1PipelineStrategyJenkinsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineStrategyJenkins(), validationEnabled);
    }
    public V1alpha1PipelineStrategyJenkinsBuilder(V1alpha1PipelineStrategyJenkinsFluent<?> fluent,V1alpha1PipelineStrategyJenkins instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineStrategyJenkinsBuilder(V1alpha1PipelineStrategyJenkinsFluent<?> fluent,V1alpha1PipelineStrategyJenkins instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withJenkinsfile(instance.getJenkinsfile());

            fluent.withJenkinsfilePath(instance.getJenkinsfilePath());

            fluent.withMultiBranch(instance.getMultiBranch());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineStrategyJenkinsBuilder(V1alpha1PipelineStrategyJenkins instance){
            this(instance,true);
    }
    public V1alpha1PipelineStrategyJenkinsBuilder(V1alpha1PipelineStrategyJenkins instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withJenkinsfile(instance.getJenkinsfile());

            this.withJenkinsfilePath(instance.getJenkinsfilePath());

            this.withMultiBranch(instance.getMultiBranch());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineStrategyJenkins build(){
            V1alpha1PipelineStrategyJenkins buildable = new V1alpha1PipelineStrategyJenkins();
            buildable.setJenkinsfile(fluent.getJenkinsfile());
            buildable.setJenkinsfilePath(fluent.getJenkinsfilePath());
            buildable.setMultiBranch(fluent.getMultiBranch());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineStrategyJenkinsBuilder that = (V1alpha1PipelineStrategyJenkinsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
