package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PipelineConfigBuilder extends V1alpha1PipelineConfigFluentImpl<V1alpha1PipelineConfigBuilder> implements VisitableBuilder<V1alpha1PipelineConfig,V1alpha1PipelineConfigBuilder>{

    V1alpha1PipelineConfigFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PipelineConfigBuilder(){
            this(true);
    }
    public V1alpha1PipelineConfigBuilder(Boolean validationEnabled){
            this(new V1alpha1PipelineConfig(), validationEnabled);
    }
    public V1alpha1PipelineConfigBuilder(V1alpha1PipelineConfigFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PipelineConfigBuilder(V1alpha1PipelineConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PipelineConfig(), validationEnabled);
    }
    public V1alpha1PipelineConfigBuilder(V1alpha1PipelineConfigFluent<?> fluent,V1alpha1PipelineConfig instance){
            this(fluent, instance, true);
    }
    public V1alpha1PipelineConfigBuilder(V1alpha1PipelineConfigFluent<?> fluent,V1alpha1PipelineConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PipelineConfigBuilder(V1alpha1PipelineConfig instance){
            this(instance,true);
    }
    public V1alpha1PipelineConfigBuilder(V1alpha1PipelineConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PipelineConfig build(){
            V1alpha1PipelineConfig buildable = new V1alpha1PipelineConfig();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PipelineConfigBuilder that = (V1alpha1PipelineConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
