package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1JenkinsBindingSpecBuilder extends V1alpha1JenkinsBindingSpecFluentImpl<V1alpha1JenkinsBindingSpecBuilder> implements VisitableBuilder<V1alpha1JenkinsBindingSpec,V1alpha1JenkinsBindingSpecBuilder>{

    V1alpha1JenkinsBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1JenkinsBindingSpecBuilder(){
            this(true);
    }
    public V1alpha1JenkinsBindingSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1JenkinsBindingSpec(), validationEnabled);
    }
    public V1alpha1JenkinsBindingSpecBuilder(V1alpha1JenkinsBindingSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1JenkinsBindingSpecBuilder(V1alpha1JenkinsBindingSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1JenkinsBindingSpec(), validationEnabled);
    }
    public V1alpha1JenkinsBindingSpecBuilder(V1alpha1JenkinsBindingSpecFluent<?> fluent,V1alpha1JenkinsBindingSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1JenkinsBindingSpecBuilder(V1alpha1JenkinsBindingSpecFluent<?> fluent,V1alpha1JenkinsBindingSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccount(instance.getAccount());

            fluent.withJenkins(instance.getJenkins());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1JenkinsBindingSpecBuilder(V1alpha1JenkinsBindingSpec instance){
            this(instance,true);
    }
    public V1alpha1JenkinsBindingSpecBuilder(V1alpha1JenkinsBindingSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccount(instance.getAccount());

            this.withJenkins(instance.getJenkins());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1JenkinsBindingSpec build(){
            V1alpha1JenkinsBindingSpec buildable = new V1alpha1JenkinsBindingSpec();
            buildable.setAccount(fluent.getAccount());
            buildable.setJenkins(fluent.getJenkins());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1JenkinsBindingSpecBuilder that = (V1alpha1JenkinsBindingSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
