package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ImageRegistryBindingRepoBuilder extends V1alpha1ImageRegistryBindingRepoFluentImpl<V1alpha1ImageRegistryBindingRepoBuilder> implements VisitableBuilder<V1alpha1ImageRegistryBindingRepo,V1alpha1ImageRegistryBindingRepoBuilder>{

    V1alpha1ImageRegistryBindingRepoFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ImageRegistryBindingRepoBuilder(){
            this(true);
    }
    public V1alpha1ImageRegistryBindingRepoBuilder(Boolean validationEnabled){
            this(new V1alpha1ImageRegistryBindingRepo(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingRepoBuilder(V1alpha1ImageRegistryBindingRepoFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ImageRegistryBindingRepoBuilder(V1alpha1ImageRegistryBindingRepoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ImageRegistryBindingRepo(), validationEnabled);
    }
    public V1alpha1ImageRegistryBindingRepoBuilder(V1alpha1ImageRegistryBindingRepoFluent<?> fluent,V1alpha1ImageRegistryBindingRepo instance){
            this(fluent, instance, true);
    }
    public V1alpha1ImageRegistryBindingRepoBuilder(V1alpha1ImageRegistryBindingRepoFluent<?> fluent,V1alpha1ImageRegistryBindingRepo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRepositories(instance.getRepositories());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ImageRegistryBindingRepoBuilder(V1alpha1ImageRegistryBindingRepo instance){
            this(instance,true);
    }
    public V1alpha1ImageRegistryBindingRepoBuilder(V1alpha1ImageRegistryBindingRepo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRepositories(instance.getRepositories());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ImageRegistryBindingRepo build(){
            V1alpha1ImageRegistryBindingRepo buildable = new V1alpha1ImageRegistryBindingRepo();
            buildable.setRepositories(fluent.getRepositories());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ImageRegistryBindingRepoBuilder that = (V1alpha1ImageRegistryBindingRepoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
