package io.alauda.devops.java.client.models;

import io.alauda.devops.java.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ArtifactRegistrySpecBuilder extends V1alpha1ArtifactRegistrySpecFluentImpl<V1alpha1ArtifactRegistrySpecBuilder> implements VisitableBuilder<V1alpha1ArtifactRegistrySpec,V1alpha1ArtifactRegistrySpecBuilder>{

    V1alpha1ArtifactRegistrySpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ArtifactRegistrySpecBuilder(){
            this(true);
    }
    public V1alpha1ArtifactRegistrySpecBuilder(Boolean validationEnabled){
            this(new V1alpha1ArtifactRegistrySpec(), validationEnabled);
    }
    public V1alpha1ArtifactRegistrySpecBuilder(V1alpha1ArtifactRegistrySpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ArtifactRegistrySpecBuilder(V1alpha1ArtifactRegistrySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ArtifactRegistrySpec(), validationEnabled);
    }
    public V1alpha1ArtifactRegistrySpecBuilder(V1alpha1ArtifactRegistrySpecFluent<?> fluent,V1alpha1ArtifactRegistrySpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1ArtifactRegistrySpecBuilder(V1alpha1ArtifactRegistrySpecFluent<?> fluent,V1alpha1ArtifactRegistrySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withArtifactRegistryArgs(instance.getArtifactRegistryArgs());

            fluent.withArtifactRegistryName(instance.getArtifactRegistryName());

            fluent.withHttp(instance.getHttp());

            fluent.withPublic(instance.isPublic());

            fluent.withSecret(instance.getSecret());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ArtifactRegistrySpecBuilder(V1alpha1ArtifactRegistrySpec instance){
            this(instance,true);
    }
    public V1alpha1ArtifactRegistrySpecBuilder(V1alpha1ArtifactRegistrySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withArtifactRegistryArgs(instance.getArtifactRegistryArgs());

            this.withArtifactRegistryName(instance.getArtifactRegistryName());

            this.withHttp(instance.getHttp());

            this.withPublic(instance.isPublic());

            this.withSecret(instance.getSecret());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ArtifactRegistrySpec build(){
            V1alpha1ArtifactRegistrySpec buildable = new V1alpha1ArtifactRegistrySpec();
            buildable.setArtifactRegistryArgs(fluent.getArtifactRegistryArgs());
            buildable.setArtifactRegistryName(fluent.getArtifactRegistryName());
            buildable.setHttp(fluent.getHttp());
            buildable.setPublic(fluent.isPublic());
            buildable.setSecret(fluent.getSecret());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ArtifactRegistrySpecBuilder that = (V1alpha1ArtifactRegistrySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
